/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.aspect.OmsAspect;

@Description(value="Calculates the aspect considering zero towards the north and counterclockwise rotation.")
@Author(name="Andrea Antonello, Erica Ghesla, Rigon Riccardo, Pisoni Silvano, Andrea Cozzini", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, OmsDrainDir, OmsFlowDirections")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_aspect")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Aspect
extends HMModel {
    @Description(value="The map of the digital elevation model (DEM).")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="Switch to define whether create the output map in degrees (default) or radiants.")
    @In
    public boolean doRadiants = false;
    @Description(value="Switch to define whether the output map values should be rounded (might make sense in the case of degree maps).")
    @In
    public boolean doRound = false;
    @Description(value="The map of aspect.")
    @UI(value="outfile")
    @In
    public String outAspect = null;

    @Execute
    public void process() throws Exception {
        OmsAspect aspect = new OmsAspect();
        aspect.inElev = this.getRaster(this.inElev);
        aspect.doRadiants = this.doRadiants;
        aspect.doRound = this.doRound;
        aspect.pm = this.pm;
        aspect.process();
        this.dumpRaster(aspect.outAspect, this.outAspect);
    }
}

