/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.curvatures.OmsCurvatures;

@Description(value="It estimates the longitudinal, normal and planar curvatures.")
@Author(name="Daniele Andreis, Antonello Andrea, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_curvatures")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Curvatures
extends HMModel {
    @Description(value="The map of the digital elevation model (DEM or pit).")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The map of profile curvatures.")
    @UI(value="outfile")
    @In
    public String outProf = null;
    @Description(value="The map of planar curvatures.")
    @UI(value="outfile")
    @In
    public String outPlan = null;
    @Description(value="The map of tangential curvatures.")
    @UI(value="outfile")
    @In
    public String outTang = null;

    @Execute
    public void process() throws Exception {
        OmsCurvatures curv = new OmsCurvatures();
        curv.pm = this.pm;
        curv.inElev = this.getRaster(this.inElev);
        curv.process();
        this.dumpRaster(curv.outProf, this.outProf);
        this.dumpRaster(curv.outPlan, this.outPlan);
        this.dumpRaster(curv.outTang, this.outTang);
    }
}

