/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.debrisflow.OmsDebrisFlow;

@Description(value="Debris flow area and deposit calculator on fans.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Debris, Raster")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_debrisflow")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class DebrisFlow
extends HMModel {
    @Description(value="The map of elevation.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The volume of the event to simulate.")
    @Unit(value="m2")
    @In
    public double pVolume = 4000.0;
    @Description(value="The mobility coefficient")
    @Unit(value="-")
    @In
    public double pMcoeff = 52.0;
    @Description(value="The deposit coefficient")
    @Unit(value="-")
    @In
    public double pDcoeff = 0.06;
    @Description(value="The start position of the simulation (easting)")
    @Unit(value="m")
    @In
    public double pEasting = 143.0;
    @Description(value="The start position of the simulation (northing)")
    @Unit(value="m")
    @In
    public double pNorthing = 604.0;
    @Description(value="The Montecarlo number.")
    @In
    public int pMontecarlo = 50;
    @Description(value="The output inundation map.")
    @UI(value="outfile")
    @In
    public String outMcs = null;
    @Description(value="The output deposit map.")
    @UI(value="outfile")
    @In
    public String outDepo = null;

    @Execute
    public void process() throws Exception {
        OmsDebrisFlow f = new OmsDebrisFlow();
        f.pm = this.pm;
        f.inElev = this.getRaster(this.inElev);
        f.pVolume = this.pVolume;
        f.pMcoeff = this.pMcoeff;
        f.pDcoeff = this.pDcoeff;
        f.pEasting = this.pEasting;
        f.pNorthing = this.pNorthing;
        f.pMontecarlo = this.pMontecarlo;
        f.process();
        this.dumpRaster(f.outMcs, this.outMcs);
        this.dumpRaster(f.outDepo, this.outDepo);
    }
}

