/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.draindir.OmsDrainDir;

@Description(value="It calculates the drainage directions minimizing the deviation from the real flow")
@Author(name="Andrea Antonello, Franceschi Silvia, Erica Ghesla, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, Pitfiller, OmsFlowDirections")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_draindir")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class DrainDir
extends HMModel {
    @Description(value="The depitted elevation model.")
    @UI(value="infile_raster")
    @In
    public String inPit = null;
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of flowdirections on the network pixels (considered only in case of LTD method). Remember that in the case of fixed flow calculation the tca has to be recalculated afterwards; the tca output in this case is not corrected.")
    @UI(value="infile_raster")
    @In
    public String inFlownet = null;
    @Description(value="The direction correction factor.")
    @In
    public float pLambda = 1.0f;
    @Description(value="Switch for the mode to use: true = LAD (default), false = LTD)).")
    @In
    public boolean doLad = true;
    @Description(value="The map of drainage directions.")
    @UI(value="outfile")
    @In
    public String outFlow = null;
    @Description(value="The map of total contributing areas.")
    @UI(value="outfile")
    @In
    public String outTca = null;

    @Execute
    public void process() throws Exception {
        OmsDrainDir draindir = new OmsDrainDir();
        draindir.inPit = this.getRaster(this.inPit);
        draindir.inFlow = this.getRaster(this.inFlow);
        draindir.inFlownet = this.getRaster(this.inFlownet);
        draindir.pLambda = this.pLambda;
        draindir.doLad = this.doLad;
        draindir.pm = this.pm;
        draindir.doProcess = this.doProcess;
        draindir.doReset = this.doReset;
        draindir.process();
        this.dumpRaster(draindir.outFlow, this.outFlow);
        this.dumpRaster(draindir.outTca, this.outTca);
    }

    public static void main(String[] args) throws Exception {
        DrainDir d = new DrainDir();
        d.inPit = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/depit_gura.tif";
        d.inFlow = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/deflow_gura.tif";
        d.outFlow = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/dedrain_gura.tif";
        d.outTca = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/detca_gura.tif";
        d.process();
    }
}

