/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorconverter.OmsDxfConverter;

@Description(value="Module to convert dxf files to geotools vecotors.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, OmsDwgConverter, Feature, Vector, Reading")
@Label(value="Vector Processing")
@Name(value="_dxfimport")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class DxfConverter
extends HMModel {
    @Description(value="The dxf file.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The output point vector.")
    @UI(value="outfile")
    @In
    public String pointsVector = null;
    @Description(value="The output lines vector.")
    @UI(value="outfile")
    @In
    public String lineVector = null;
    @Description(value="The output polygons vector.")
    @UI(value="outfile")
    @In
    public String polygonVector = null;

    @Execute
    public void process() throws Exception {
        OmsDxfConverter dxfconverter = new OmsDxfConverter();
        dxfconverter.file = this.file;
        dxfconverter.pCode = this.pCode;
        dxfconverter.pm = this.pm;
        dxfconverter.doProcess = this.doProcess;
        dxfconverter.doReset = this.doReset;
        dxfconverter.process();
        this.dumpVector(dxfconverter.pointsVector, this.pointsVector);
        this.dumpVector(dxfconverter.lineVector, this.lineVector);
        this.dumpVector(dxfconverter.polygonVector, this.polygonVector);
    }
}

