/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hillslopeanalyses.h2cd.OmsH2cd;

@Description(value="It calculates for each hillslope pixel its distance from the river networks, following the steepest descent.")
@Author(name="Erica Ghesla, Antonello Andrea, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Hillslope, Outlet, Distance")
@Label(value="HortonMachine/Hillslope")
@Name(value="_h2cd")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class H2cd
extends HMModel {
    @Description(value="The map of flowdirections")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of the network.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The optional map of the elevation used for 3d mode in pMode = 1.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The processing mode (0 = in number of pixels (default), 1 = in meters).")
    @In
    public int pMode = 0;
    @Description(value="The map of hillslope to channels distance.")
    @UI(value="outfile")
    @In
    public String outH2cd = null;

    @Execute
    public void process() throws Exception {
        OmsH2cd h2cd = new OmsH2cd();
        h2cd.inFlow = this.getRaster(this.inFlow);
        h2cd.inNet = this.getRaster(this.inNet);
        h2cd.inElev = this.getRaster(this.inElev);
        h2cd.pMode = this.pMode;
        h2cd.pm = this.pm;
        h2cd.doProcess = this.doProcess;
        h2cd.doReset = this.doReset;
        h2cd.process();
        this.dumpRaster(h2cd.outH2cd, this.outH2cd);
    }
}

