/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.intensityclassifier.OmsIntensityClassifierDebrisFlowTN;

@Description(value="Module for the calculation of the debris flow intensity following TN guidelines.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Flooding")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_intensityclassifierdebrisflowtn")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class IntensityClassifierDebrisFlowTN
extends HMModel {
    @Description(value="The map of the water depth.")
    @UI(value="infile_raster")
    @Unit(value="m")
    @In
    public String inWaterDepth;
    @Description(value="The upper threshold value for the water depth.")
    @Unit(value="m")
    @In
    public Double pUpperThresWaterdepth = 1.0;
    @Description(value="The lower threshold value for the water depth.")
    @Unit(value="m")
    @In
    public Double pLowerThresWaterdepth = 0.5;
    @Description(value="The map of the water velocity outside of the river bed.")
    @UI(value="infile_raster")
    @Unit(value="m/s")
    @In
    public String inVelocity;
    @Description(value="The upper threshold value of the water velocity outside of the river bed.")
    @Unit(value="m/s")
    @In
    public Double pUpperThresVelocity = 1.0;
    @Description(value="The lower threshold value of the water velocity outside of the river bed.")
    @Unit(value="m/s")
    @In
    public Double pLowerThresVelocity = 0.5;
    @Description(value="The map of the thickness of the deposits outside the bed of the river.")
    @UI(value="infile_raster")
    @Unit(value="m")
    @In
    public String inDepositsThickness;
    @Description(value="The upper threshold value for the deposits thickness.")
    @Unit(value="m")
    @In
    public Double pUpperThresDepositsThickness = 1.0;
    @Description(value="The lower threshold value for the deposits thickness.")
    @Unit(value="m")
    @In
    public Double pLowerThresDepositsThickness = 0.5;
    @Description(value="The map of erosion depth.")
    @UI(value="infile_raster")
    @Unit(value="m")
    @In
    public String inErosionDepth;
    @Description(value="The upper threshold value for the erosion depth.")
    @Unit(value="m")
    @In
    public Double pUpperThresErosionDepth = 2.0;
    @Description(value="The lower threshold value for the erosion depth.")
    @Unit(value="m")
    @In
    public Double pLowerThresErosionDepth = 0.5;
    @Description(value="The map of flooding intensity.")
    @UI(value="outfile")
    @In
    public String outIntensity = null;

    @Execute
    public void process() throws Exception {
        OmsIntensityClassifierDebrisFlowTN intensityclassifier = new OmsIntensityClassifierDebrisFlowTN();
        intensityclassifier.inWaterDepth = this.getRaster(this.inWaterDepth);
        intensityclassifier.inVelocity = this.getRaster(this.inVelocity);
        intensityclassifier.inDepositsThickness = this.getRaster(this.inDepositsThickness);
        intensityclassifier.inErosionDepth = this.getRaster(this.inErosionDepth);
        intensityclassifier.pUpperThresWaterdepth = this.pUpperThresWaterdepth;
        intensityclassifier.pLowerThresWaterdepth = this.pLowerThresWaterdepth;
        intensityclassifier.pUpperThresVelocity = this.pUpperThresVelocity;
        intensityclassifier.pLowerThresVelocity = this.pLowerThresVelocity;
        intensityclassifier.pUpperThresDepositsThickness = this.pUpperThresDepositsThickness;
        intensityclassifier.pLowerThresDepositsThickness = this.pLowerThresDepositsThickness;
        intensityclassifier.pUpperThresErosionDepth = this.pUpperThresErosionDepth;
        intensityclassifier.pLowerThresErosionDepth = this.pLowerThresErosionDepth;
        intensityclassifier.pm = this.pm;
        intensityclassifier.doProcess = this.doProcess;
        intensityclassifier.doReset = this.doReset;
        intensityclassifier.process();
        this.dumpRaster(intensityclassifier.outIntensity, this.outIntensity);
    }
}

