/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.statistics.kerneldensity.OmsKernelDensity;

@Description(value="Kernel Density Estimator (based on the Jaitools project).")
@Author(name="Andrea Antonello", contact="http://jaitools.org, www.hydrologis.com")
@Keywords(value="Kernel Density, Raster")
@Label(value="Raster Processing")
@Name(value="_kerneldenisty")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class KernelDensity
extends HMModel {
    @Description(value="The input map.")
    @UI(value="infile_raster")
    @In
    public String inMap = null;
    @Description(value="The kernel to use.")
    @In
    public int pKernel = 3;
    @Description(value="The kernel radius to use in cells (default = 10).")
    @In
    public int pRadius = 10;
    @Description(value="Use a constant value for the existing input map values instead of the real map value (default = false).")
    @In
    public boolean doConstant = false;
    @Description(value="The kernel density estimation.")
    @UI(value="outfile")
    @In
    public String outDensity = null;

    @Execute
    public void process() throws Exception {
        OmsKernelDensity omskerneldensity = new OmsKernelDensity();
        omskerneldensity.inMap = this.getRaster(this.inMap);
        omskerneldensity.pKernel = this.pKernel;
        omskerneldensity.pRadius = this.pRadius;
        omskerneldensity.doConstant = this.doConstant;
        omskerneldensity.pm = this.pm;
        omskerneldensity.doProcess = this.doProcess;
        omskerneldensity.doReset = this.doReset;
        omskerneldensity.process();
        this.dumpRaster(omskerneldensity.outDensity, this.outDensity);
    }
}

