/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.timedependent.OmsTimeSeriesIteratorReader;
import org.hortonmachine.gears.io.timedependent.OmsTimeSeriesIteratorWriter;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.statistics.kriging.old.OmsKriging;

@Description(value="Ordinary kriging algorithm.")
@Author(name="Giuseppe Formetta, Daniele Andreis, Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com,  http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="OmsKriging, Hydrology")
@Label(value="HortonMachine/Statistics")
@Name(value="_kriging")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class Kriging
extends HMModel {
    @Description(value="The vector of the measurement point, containing the position of the stations.")
    @UI(value="infile_vector")
    @In
    public String inStations = null;
    @Description(value="The file with the measured data, to be interpolated.")
    @UI(value="infile_vector")
    @In
    public String inData = null;
    @Description(value="The vector of the points in which the data have to be interpolated.")
    @UI(value="infile_vector")
    @In
    public String inInterpolate = null;
    @Description(value="The collection of the points in which the data needs to be interpolated.")
    @UI(value="infile_raster")
    @In
    public String inInterpolationGrid = null;
    @Description(value="The field of the vector of stations, defining the id.")
    @In
    public String fStationsid = null;
    @Description(value="The field of the vector of stations, defining the elevation.")
    @In
    public String fStationsZ = null;
    @Description(value="The field of the interpolated vector points, defining the id.")
    @In
    public String fInterpolateid = null;
    @Description(value="The field of the interpolated vector points, defining the elevation.")
    @In
    public String fPointZ = null;
    @Description(value="The interpolation mode (0 = interpolate on irregular grid, 1 = interpolate on regular grid).")
    @In
    public int pMode = 0;
    @Description(value="The integral scale as comma separated values.")
    @In
    public String pIntegralscale = null;
    @Description(value="The variance.")
    @In
    public double pVariance = 0.0;
    @Description(value="Switch for logaritmic run selection.")
    @In
    public boolean doLogarithmic = false;
    public int defaultVariogramMode = 0;
    @Description(value="The type of theoretical semivariogram: 0 = Gaussian; 1 = Exponential.")
    @In
    public double pSemivariogramType = 0.0;
    @Description(value="Include zeros in computations (default is true).")
    @In
    public boolean doIncludezero = true;
    @Description(value="The range if the models runs with the gaussian variogram.")
    @In
    public double pA;
    @Description(value="The sill if the models runs with the gaussian variogram.")
    @In
    public double pS;
    @Description(value="Is the nugget if the models runs with the gaussian variogram.")
    @In
    public double pNug;
    @Description(value="The interpolated gridded data (for mode 2 and 3.")
    @UI(value="outfile")
    @In
    public String outGrid = null;
    @Description(value="The interpolated data (for mode 0 and 1).")
    @UI(value="outfile")
    @Out
    public String outData = null;

    @Execute
    public void process() throws Exception {
        OmsTimeSeriesIteratorReader reader = new OmsTimeSeriesIteratorReader();
        reader.file = this.inData;
        reader.idfield = this.fStationsid;
        reader.fileNovalue = "-9999";
        reader.initProcess();
        OmsKriging kriging = new OmsKriging();
        kriging.inStations = this.getVector(this.inStations);
        kriging.fStationsid = this.fStationsid;
        kriging.fStationsZ = this.fStationsZ;
        kriging.inInterpolate = this.getVector(this.inInterpolate);
        kriging.fInterpolateid = this.fInterpolateid;
        kriging.fPointZ = this.fPointZ;
        kriging.pMode = this.pMode;
        if (this.pIntegralscale != null && this.pIntegralscale.trim().length() > 0) {
            String[] split = this.pIntegralscale.split(",");
            double[] integralScaleDouble = new double[split.length];
            for (int i = 0; i < split.length; ++i) {
                try {
                    integralScaleDouble[i] = Double.parseDouble(split[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new ModelsIllegalargumentException("Problems with integral scale: " + this.pIntegralscale, (Object)this, this.pm);
                }
            }
            kriging.pIntegralscale = integralScaleDouble;
        }
        kriging.pVariance = this.pVariance;
        kriging.doLogarithmic = this.doLogarithmic;
        GridCoverage2D interpolationGrid = this.getRaster(this.inInterpolationGrid);
        if (interpolationGrid != null) {
            kriging.inInterpolationGrid = interpolationGrid.getGridGeometry();
        }
        kriging.defaultVariogramMode = this.defaultVariogramMode;
        kriging.pSemivariogramType = this.pSemivariogramType;
        kriging.doIncludezero = this.doIncludezero;
        kriging.pA = this.pA;
        kriging.pS = this.pS;
        kriging.pNug = this.pNug;
        kriging.pm = this.pm;
        kriging.doProcess = this.doProcess;
        kriging.doReset = this.doReset;
        OmsTimeSeriesIteratorWriter writer = null;
        this.pm.beginTask("Processing...", -1);
        while (reader.doProcess) {
            HashMap id2ValueMap;
            reader.nextRecord();
            if (writer == null) {
                writer = new OmsTimeSeriesIteratorWriter();
                writer.file = this.outData;
                writer.tStart = reader.tStart;
                writer.tTimestep = reader.tTimestep;
            }
            this.pm.message("timestep: " + reader.tCurrent);
            kriging.inData = id2ValueMap = reader.outData;
            kriging.process();
            writer.inData = kriging.outData;
            writer.writeNextLine();
            this.dumpRaster(kriging.outGrid, this.outGrid);
        }
        this.pm.done();
        reader.close();
        writer.close();
    }
}

