/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.LWFields;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW07_HydraulicParamsToSectionsAdder;

@Description(value="Adds to the layer of section points the hydraulic parameters of the transversal section.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="hydraulic, network, vector, point, bankflull, width")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="_lw07_hydraulicparamstosectionsadder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW07_HydraulicParamsToSectionsAdder
extends HMModel
implements LWFields {
    @Description(value="The input terrain elevation raster map.")
    @UI(value="infile_raster")
    @In
    public String inDtm = null;
    @Description(value="The input hierarchy network layer")
    @UI(value="infile_vector")
    @In
    public String inNet = null;
    @Description(value="The input hierarchy point network layer.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The input discharge value")
    @Unit(value="m3/s")
    @In
    public double pDischarge;
    @Description(value="Time interval.")
    @Unit(value="millisec")
    @In
    public long pDeltaTMillis = 5000L;
    @Description(value="Boolean factor to define if the 1D model has to run with bankfull width or with maximum widening width.")
    @In
    public boolean doMaxWidening = false;
    @Description(value="Output file with levels.")
    @UI(value="outfile")
    @In
    public String outputLevelFile;
    @Description(value="Output file with the quantities related to discharge.")
    @UI(value="outfile")
    @In
    public String outputDischargeFile;
    @Description(value="Adds to the layer of section points the hydraulic parameters of the trasversal section.")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;
    @Description(value="The output line shapefile with the extracted transversal sections.")
    @UI(value="outfile")
    @In
    public String outTransSect = null;

    @Execute
    public void process() throws Exception {
        OmsLW07_HydraulicParamsToSectionsAdder ex = new OmsLW07_HydraulicParamsToSectionsAdder();
        ex.inDtm = this.getRaster(this.inDtm);
        ex.inNet = this.getVector(this.inNet);
        ex.inNetPoints = this.getVector(this.inNetPoints);
        ex.pDischarge = this.pDischarge;
        ex.pDeltaTMillis = this.pDeltaTMillis;
        ex.doMaxWidening = this.doMaxWidening;
        ex.outputLevelFile = this.outputLevelFile;
        ex.outputDischargeFile = this.outputDischargeFile;
        ex.pm = this.pm;
        ex.process();
        this.dumpVector(ex.outNetPoints, this.outNetPoints);
        this.dumpVector(ex.outTransSect, this.outTransSect);
    }
}

