/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW10_SingleTree_AreaToNetpointAssociator;

@Description(value="Calculate median vegetation height and total timber volume of the vegetation on unstable and connected areas of each subbasin.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, bankflull, width, inundation, vegetation")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="_lw10_singletreeareatonetpointassociator")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW10_SingleTree_AreaToNetpointAssociator
extends HMModel {
    @Description(value="The input hierarchy point network layer.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The input layer of single trees.")
    @UI(value="infile_vector")
    @In
    public String inTreePoints = null;
    @Description(value="The input polygon layer with the inundation areas.")
    @UI(value="infile_vector")
    @In
    public String inInundationArea = null;
    @Description(value="The input flow directions raster map.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The input total contributing areas raster map.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The input network raster map.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The input downslope connectivity index raster map.")
    @UI(value="infile_raster")
    @In
    public String inConnectivity = null;
    @Description(value="Threshold on connectivity map for extracting unstable connected pixels of the basins.")
    @In
    public double pConnectivityThreshold = 4.0;
    @Description(value="Coefficient of the second order term of tree height of the allometric function relating DBH to H of the trees.")
    @In
    public double pAllometricCoeff2ndOrder = 0.0096;
    @Description(value="Coefficient of the first order term of tree height of the allometric function relating DBH to H of the trees.")
    @In
    public double pAllometricCoeff1stOrder = 1.298;
    @Description(value="Coefficient of the first order term of tree height of the allometric function relating tree volume to DBH and H.")
    @In
    public double pAllometricCoeffVolume = 3.68048E-5;
    @Description(value="Percentile of the distribution of tree heights and DBH to be used for the evaluation of the representative height and DBH contributing in each section from the hillslopes.")
    @In
    public int pRepresentingHeightDbhPercentile = 50;
    @Description(value="The tree taper to use to evaluate the effective length of the trees (rastremation index)")
    @Unit(value="cm/m")
    @In
    public double pTreeTaper = 3.0;
    @Description(value="The value of the diameter limit under which the log is flexible used to evaluate the effective length of the trees.")
    @Unit(value="cm")
    @In
    public double pFlexibleDiameterLimit = 5.0;
    @Description(value="The output points network layer with the additional attributes vegetation height and timber volume.")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;
    @Description(value="The output netnumbering raster map.")
    @UI(value="outfile")
    @In
    public String outNetnum = null;
    @Description(value="The output tree points layer with additional attribute of the correspondent river section where it will contribute.")
    @UI(value="outfile")
    @In
    public String outTreePoints = null;
    @Description(value="The output subbasins raster map.")
    @UI(value="outfile")
    @In
    public String outBasins = null;

    @Execute
    public void process() throws Exception {
        OmsLW10_SingleTree_AreaToNetpointAssociator ex = new OmsLW10_SingleTree_AreaToNetpointAssociator();
        ex.inNetPoints = this.getVector(this.inNetPoints);
        ex.inTreePoints = this.getVector(this.inTreePoints);
        ex.inInundationArea = this.getVector(this.inInundationArea);
        ex.inFlow = this.getRaster(this.inFlow);
        ex.inTca = this.getRaster(this.inTca);
        ex.inNet = this.getRaster(this.inNet);
        ex.inConnectivity = this.getRaster(this.inConnectivity);
        ex.pConnectivityThreshold = this.pConnectivityThreshold;
        ex.pAllometricCoeff2ndOrder = this.pAllometricCoeff2ndOrder;
        ex.pAllometricCoeff1stOrder = this.pAllometricCoeff1stOrder;
        ex.pAllometricCoeffVolume = this.pAllometricCoeffVolume;
        ex.pRepresentingHeightDbhPercentile = this.pRepresentingHeightDbhPercentile;
        ex.pTreeTaper = this.pTreeTaper;
        ex.pFlexibleDiameterLimit = this.pFlexibleDiameterLimit;
        ex.pm = this.pm;
        ex.process();
        this.dumpVector(ex.outNetPoints, this.outNetPoints);
        this.dumpVector(ex.outTreePoints, this.outTreePoints);
        this.dumpRaster(ex.outNetnum, this.outNetnum);
        this.dumpRaster(ex.outBasins, this.outBasins);
    }
}

