/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.function.Predicate;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Filter and/or modify a las file.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, filter")
@Label(value="Vector Processing")
@Name(value="lasfilter")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasFilter
extends HMModel {
    @Description(value="The LAS file.")
    @UI(value="infile_las")
    @In
    public String inFile;
    @Description(value="The filter predicate to apply.")
    @In
    public Predicate<LasRecord> filter;
    @Description(value="The output file.")
    @UI(value="outfile")
    @In
    public String outFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFile, this.filter, this.outFile});
        File lasFile = new File(this.inFile);
        try (ALasReader lasReader = ALasReader.getReader((File)lasFile);){
            lasReader.open();
            ILasHeader header = lasReader.getHeader();
            CoordinateReferenceSystem crs = header.getCrs();
            if (crs == null) {
                this.pm.errorMessage("No CRS supplies, folding back on Generic 2D");
                crs = DefaultEngineeringCRS.GENERIC_2D;
            }
            int recordsCount = (int)header.getRecordsCount();
            this.pm.beginTask("Filtering data...", recordsCount);
            try (ALasWriter lasWriter = ALasWriter.getWriter((File)new File(this.outFile), (CoordinateReferenceSystem)crs);){
                lasWriter.setBounds(header);
                lasWriter.open();
                while (lasReader.hasNextPoint()) {
                    this.pm.worked(1);
                    LasRecord lr = lasReader.getNextPoint();
                    if (!this.filter.test(lr)) continue;
                    lasWriter.addPoint(lr);
                }
            }
            finally {
                this.pm.done();
            }
        }
    }
}

