/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.smoothing.OmsLineSmootherMcMaster;

@Description(value="The McMasters Sliding Averaging smoothing algorithm.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Smoothing, Vector, OmsLineSmootherJaitools")
@Label(value="Vector Processing")
@Name(value="_linesmoother")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class LineSmootherMcMaster
extends HMModel {
    @Description(value="The vector containing the lines to be smoothed.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The number of points to consider in every smoothing step (default = 7).")
    @In
    public int pLookahead = 7;
    @Description(value="Minimum length for a line to be smoothed.")
    @In
    public int pLimit = 0;
    @Description(value="Slide parameter.")
    @In
    public double pSlide = 0.9;
    @Description(value="Densifier interval.")
    @In
    public Double pDensify = null;
    @Description(value="Simplifier tollerance.")
    @In
    public Double pSimplify = null;
    @Description(value="The vector with smoothed features.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        OmsLineSmootherMcMaster linesmoothermcmaster = new OmsLineSmootherMcMaster();
        linesmoothermcmaster.inVector = this.getVector(this.inVector);
        linesmoothermcmaster.pLookahead = this.pLookahead;
        linesmoothermcmaster.pLimit = this.pLimit;
        linesmoothermcmaster.pSlide = this.pSlide;
        linesmoothermcmaster.pDensify = this.pDensify;
        linesmoothermcmaster.pSimplify = this.pSimplify;
        linesmoothermcmaster.pm = this.pm;
        linesmoothermcmaster.doProcess = this.doProcess;
        linesmoothermcmaster.doReset = this.doReset;
        linesmoothermcmaster.process();
        this.dumpVector(linesmoothermcmaster.outVector, this.outVector);
    }
}

