/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.polygonize.OmsLinesPolygonizer;

@Description(value="Polygonizes a layer of lines.")
@Author(name="Antonio Falciano, Andrea Antonello", contact="afalciano@yahoo.it, http://blog.spaziogis.it/, http://www.hydrologis.com")
@Keywords(value="Vector, Polygonize")
@Label(value="Vector Processing")
@Name(value="_linespolygonizer")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LinesPolygonizer
extends HMModel {
    @Description(value="The map of lines to polygonize.")
    @UI(value="infile_vector")
    @In
    public String inMap = null;
    @Description(value="The map of points containing the id to put in the polygons attributes (optional).")
    @UI(value="infile_vector")
    @In
    public String inPoints = null;
    @Description(value="The field of the points layer containing the id for the polygons (necessary if inPoints is defined).")
    @In
    public String fId = null;
    @Description(value="The field of the polygonized layer containing the id (default is 'id').")
    @In
    public String fNewId = "id";
    @Description(value="The map of polygons.")
    @UI(value="outfile")
    @In
    public String outMap = null;

    @Execute
    public void process() throws Exception {
        OmsLinesPolygonizer omslinespolygonizer = new OmsLinesPolygonizer();
        omslinespolygonizer.inMap = this.getVector(this.inMap);
        omslinespolygonizer.inPoints = this.getVector(this.inPoints);
        omslinespolygonizer.fId = this.fId;
        omslinespolygonizer.fNewId = this.fNewId;
        omslinespolygonizer.pm = this.pm;
        omslinespolygonizer.doProcess = this.doProcess;
        omslinespolygonizer.doReset = this.doReset;
        omslinespolygonizer.process();
        this.dumpVector(omslinespolygonizer.outMap, this.outMap);
    }
}

