/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.linesrasterizer.OmsLinesRasterizer;

@Description(value="Module to convert vector lines to raster.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Lines")
@Label(value="Raster Processing")
@Name(value="_rasterizelines")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LinesRasterizer
extends HMModel {
    @Description(value="The lines vector.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="The optional field of the vector to take the category from.")
    @In
    public String fCat;
    @Description(value="The category to use if no field was set.")
    @In
    public double pCat = 1.0;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsLinesRasterizer linesrasterizer = new OmsLinesRasterizer();
        linesrasterizer.inVector = this.getVector(this.inVector);
        linesrasterizer.fCat = this.fCat;
        linesrasterizer.pCat = this.pCat;
        linesrasterizer.pNorth = this.pNorth;
        linesrasterizer.pSouth = this.pSouth;
        linesrasterizer.pWest = this.pWest;
        linesrasterizer.pEast = this.pEast;
        linesrasterizer.pRows = this.pRows;
        linesrasterizer.pCols = this.pCols;
        linesrasterizer.pm = this.pm;
        linesrasterizer.doProcess = this.doProcess;
        linesrasterizer.doReset = this.doReset;
        linesrasterizer.process();
        this.dumpRaster(linesrasterizer.outRaster, this.outRaster);
    }
}

