/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.netdiff.OmsNetDiff;

@Description(value="Calculates the difference between the value of a quantity in one point and the value of the same quantity in another point across a basin")
@Author(name="Daniele Andreis, Erica Ghesla, Antonello Andrea, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="")
@Keywords(value="Network, Pitfiller, OmsDrainDir, OmsFlowDirections")
@Label(value="HortonMachine/Network")
@Name(value="_netdiff")
@Status(value=40)
@License(value="GPL3")
public class NetDiff
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of the stream.")
    @UI(value="infile_raster")
    @In
    public String inStream = null;
    @Description(value="The map of to evaluate the difference.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="The map of difference.")
    @UI(value="outfile")
    @In
    public String outDiff = null;

    @Execute
    public void process() throws Exception {
        OmsNetDiff netdiff = new OmsNetDiff();
        netdiff.inFlow = this.getRaster(this.inFlow);
        netdiff.inStream = this.getRaster(this.inStream);
        netdiff.inRaster = this.getRaster(this.inRaster);
        netdiff.pm = this.pm;
        netdiff.doProcess = this.doProcess;
        netdiff.doReset = this.doReset;
        netdiff.process();
        this.dumpRaster(netdiff.outDiff, this.outDiff);
    }
}

