/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONObject;

@Description(value="PDAL filter.outliers command: Extended Local Minimum")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, filter, outliers, docker")
@Label(value="Pdal")
@Name(value="_pdal_filter_outliers")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalFilterOutliers
extends PdalDockerModel {
    @Description(value="The pdal file to filter.")
    @UI(value="infile_las")
    @In
    public String inPath = null;
    @Description(value="The output file name.")
    @In
    public String outName = null;
    @Description(value="The classification value to apply to outliers.")
    @In
    public Double pClass = 7.0;
    @Description(value="The outlier removal method (statistical or radius).")
    @In
    public String pMethod = "statistical";
    @Description(value="Minimum number of neighbors in radius (radius method only).")
    @In
    public Double pMinK = 2.0;
    @Description(value="Radius (radius method only).")
    @In
    public Double pRadius = 1.0;
    @Description(value="Mean number of neighbors (statistical method only).")
    @In
    public Double pMeanK = 8.0;
    @Description(value="Standard deviation threshold (statistical method only).")
    @In
    public Double pMultiplier = 2.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();
                JSONObject filter = new JSONObject();
                filter.put("type", (Object)"filters.outlier");
                filter.put("method", (Object)this.pMethod);
                if (this.pClass != null) {
                    filter.put("class", (Object)this.pClass);
                }
                if (this.pMinK != null) {
                    filter.put("min_k", (Object)this.pMinK);
                }
                if (this.pMeanK != null) {
                    filter.put("mean_k", (Object)this.pMeanK);
                }
                if (this.pRadius != null) {
                    filter.put("radius", (Object)this.pRadius);
                }
                if (this.pMultiplier != null) {
                    filter.put("multiplier", (Object)this.pMultiplier);
                }
                String pipelineJson = this.getPipelineJson(inName, this.outName, filter);
                this.pm.message("Running pipeline with filter:");
                this.pm.message(pipelineJson);
                File pipelineFile = this.getPipelineFile(workspaceFile, pipelineJson);
                String cmd = "pdal pipeline " + pipelineFile.getName();
                this.startContainer(workspace);
                this.pm.beginTask("Running command...", -1);
                this.execCommand(cmd);
                this.pm.done();
                pipelineFile.delete();
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalFilterOutliers i = new PdalFilterOutliers();
        i.inPath = "/Users/hydrologis/data/las/EXAMPLE_river.las";
        i.pMethod = "statistical";
        i.pMultiplier = 2.0;
        i.pMeanK = 10.0;
        i.outName = "filtered.las";
        i.process();
    }
}

