/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONObject;

@Description(value="PDAL filter.pmf command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, filter, pmf, docker")
@Label(value="Pdal")
@Name(value="_pdal_filter_pmf")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalFilterPmf
extends PdalDockerModel {
    @Description(value="The pdal file to filter.")
    @UI(value="infile_las")
    @In
    public String inPath = null;
    @Description(value="The output file name.")
    @In
    public String outName = null;
    @Description(value="Slope")
    @In
    public Double pSlope = 1.0;
    @Description(value="Use exponential growth for window sizes?")
    @In
    public boolean doExponential = true;
    @Description(value="Cell Size.")
    @In
    public Double pCellSize = 1.0;
    @Description(value="Maximum distance.")
    @In
    public Double pMaxDistance = 2.5;
    @Description(value="Maximum window size.")
    @In
    public Double pMaxWindowSize = 33.0;
    @Description(value="Initial distance.")
    @In
    public Double pInitialDistance = 0.15;
    @Description(value="An optional pre pmf input classification filter.")
    @In
    public Integer pInClassification = null;
    @Description(value="An optional post pmf output classification filter.")
    @In
    public Integer pOutClassification = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();
                ArrayList<JSONObject> filters = new ArrayList<JSONObject>();
                if (this.pInClassification != null) {
                    JSONObject inClassFilter = new JSONObject();
                    inClassFilter.put("type", (Object)"filters.range");
                    inClassFilter.put("limits", (Object)("Classification![" + this.pInClassification + ":" + this.pInClassification + "]"));
                    filters.add(inClassFilter);
                }
                JSONObject filter = new JSONObject();
                filter.put("type", (Object)"filters.pmf");
                filter.put("exponential", this.doExponential);
                if (this.pSlope != null) {
                    filter.put("slope", (Object)this.pSlope);
                }
                if (this.pCellSize != null) {
                    filter.put("cell_size", (Object)this.pCellSize);
                }
                if (this.pMaxDistance != null) {
                    filter.put("max_distance", (Object)this.pMaxDistance);
                }
                if (this.pMaxWindowSize != null) {
                    filter.put("max_window_size", (Object)this.pMaxWindowSize);
                }
                if (this.pInitialDistance != null) {
                    filter.put("initial_distance", (Object)this.pInitialDistance);
                }
                filters.add(filter);
                if (this.pOutClassification != null) {
                    JSONObject outClassFilter = new JSONObject();
                    outClassFilter.put("type", (Object)"filters.range");
                    outClassFilter.put("limits", (Object)("Classification![" + this.pOutClassification + ":" + this.pOutClassification + "]"));
                    filters.add(outClassFilter);
                }
                String pipelineJson = this.getPipelineJson(inName, this.outName, filters.toArray(new JSONObject[filters.size()]));
                this.pm.message("Running pipeline with filter:");
                this.pm.message(pipelineJson);
                File pipelineFile = this.getPipelineFile(workspaceFile, pipelineJson);
                String cmd = "pdal pipeline " + pipelineFile.getName();
                this.startContainer(workspace);
                this.pm.beginTask("Running command...", -1);
                this.execCommand(cmd);
                this.pm.done();
                pipelineFile.delete();
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalFilterPmf i = new PdalFilterPmf();
        i.inPath = "/Users/hydrologis/data/las/EXAMPLE_river.las";
        i.outName = "filtered.las";
        i.process();
    }
}

