/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONObject;

@Description(value="PDAL filter.smrf command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, filter, smrf, docker")
@Label(value="Pdal")
@Name(value="_pdal_filter_smrf")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalFilterSmrf
extends PdalDockerModel {
    @Description(value="The pdal file to filter.")
    @UI(value="infile_las")
    @In
    public String inPath = null;
    @Description(value="The output file name.")
    @In
    public String outName = null;
    @Description(value="Cell Size.")
    @In
    public Double pCellSize = 1.0;
    @Description(value="Elevation scalar.")
    @In
    public Double pScalar = 1.25;
    @Description(value="Slope (rise over run)")
    @In
    public Double pSlope = 0.15;
    @Description(value="Elevation threshold.")
    @In
    public Double pThreshold = 0.5;
    @Description(value="Max window size.")
    @In
    public Double pWindow = 18.0;
    @Description(value="List of impulses to extract. Can be one or more of: first, last, intermediate, only")
    @In
    public String pReturns = "last, only";
    @Description(value="An optional post smrf output classification filter.")
    @In
    public Integer pOutClassification = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();
                ArrayList<JSONObject> filters = new ArrayList<JSONObject>();
                JSONObject filter = new JSONObject();
                filter.put("type", (Object)"filters.smrf");
                if (this.pSlope != null) {
                    filter.put("slope", (Object)this.pSlope);
                }
                if (this.pCellSize != null) {
                    filter.put("cell", (Object)this.pCellSize);
                }
                if (this.pScalar != null) {
                    filter.put("scalar", (Object)this.pScalar);
                }
                if (this.pWindow != null) {
                    filter.put("window", (Object)this.pWindow);
                }
                if (this.pThreshold != null) {
                    filter.put("threshold", (Object)this.pThreshold);
                }
                if (this.pReturns != null) {
                    filter.put("returns", (Object)this.pReturns);
                }
                filters.add(filter);
                if (this.pOutClassification != null) {
                    JSONObject outClassFilter = new JSONObject();
                    outClassFilter.put("type", (Object)"filters.range");
                    outClassFilter.put("limits", (Object)("Classification![" + this.pOutClassification + ":" + this.pOutClassification + "]"));
                    filters.add(outClassFilter);
                }
                String pipelineJson = this.getPipelineJson(inName, this.outName, filters.toArray(new JSONObject[filters.size()]));
                this.pm.message("Running pipeline with filter:");
                this.pm.message(pipelineJson);
                File pipelineFile = this.getPipelineFile(workspaceFile, pipelineJson);
                String cmd = "pdal pipeline " + pipelineFile.getName();
                this.startContainer(workspace);
                this.pm.beginTask("Running command...", -1);
                this.execCommand(cmd);
                this.pm.done();
                pipelineFile.delete();
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalFilterSmrf i = new PdalFilterSmrf();
        i.inPath = "/Users/hydrologis/data/las/EXAMPLE_river.las";
        i.outName = "filtered.las";
        i.process();
    }
}

