/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.demmanipulation.pitfiller.OmsPitfiller;

@Description(value="It fills the depression points present within a DEM.")
@Author(name="David Tarboton, Andrea Antonello", contact="http://www.neng.usu.edu/cee/faculty/dtarb/tardem.html#programs, http://www.hydrologis.com")
@Keywords(value="Dem manipulation, Geomorphology, OmsDrainDir")
@Label(value="HortonMachine/Dem Manipulation")
@Name(value="_pit")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Pitfiller
extends HMModel {
    @Description(value="The map of digital elevation model (DEM).")
    @UI(value="infile_raster")
    @In
    public String inElev;
    @Description(value="The depitted elevation map.")
    @UI(value="outfile")
    @In
    public String outPit = null;

    @Execute
    public void process() throws Exception {
        OmsPitfiller pitfiller = new OmsPitfiller();
        pitfiller.inElev = this.getRaster(this.inElev);
        pitfiller.pm = this.pm;
        pitfiller.doProcess = this.doProcess;
        pitfiller.doReset = this.doReset;
        pitfiller.process();
        this.dumpRaster(pitfiller.outPit, this.outPit);
    }
}

