/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rangelookup.OmsRangeLookup;

@Description(value="Module for raster rangelookup.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Rangelookup")
@Label(value="Raster Processing")
@Name(value="_rrangelookup")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RangeLookup
extends HMModel {
    @Description(value="The raster that has to be processed.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The ranges in the form [r1l r1h),[r2l r2h]")
    @In
    public String pRanges;
    @Description(value="The classes to substitute in the same order of the ranges (in the form 1,2)")
    @In
    public String pClasses;
    @Description(value="The processed raster.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        OmsRangeLookup rangelookup = new OmsRangeLookup();
        rangelookup.inRaster = this.getRaster(this.inRaster);
        rangelookup.pRanges = this.pRanges;
        rangelookup.pClasses = this.pClasses;
        rangelookup.pm = this.pm;
        rangelookup.doProcess = this.doProcess;
        rangelookup.doReset = this.doReset;
        rangelookup.process();
        this.dumpRaster(rangelookup.outRaster, this.outRaster);
    }
}

