/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Name;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.modules.r.rasterconverter.OmsRasterConverter;

@Name(value="rconvert")
public class RasterConverter
extends OmsRasterConverter {
    @Description(value="The input raster.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The requested resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The requested resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="An optional type for the conversion.")
    @UI(value="combo:INTEGER,FLOAT,DOUBLE")
    @In
    public String pOutType = "";
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterReader rasterreader = new OmsRasterReader();
        rasterreader.file = this.inRaster;
        rasterreader.pNorth = this.pNorth;
        rasterreader.pSouth = this.pSouth;
        rasterreader.pWest = this.pWest;
        rasterreader.pEast = this.pEast;
        rasterreader.pXres = this.pXres;
        rasterreader.pYres = this.pYres;
        rasterreader.pRows = this.pRows;
        rasterreader.pCols = this.pCols;
        rasterreader.pm = this.pm;
        rasterreader.process();
        OmsRasterConverter rasterconverter = new OmsRasterConverter();
        rasterconverter.inRaster = rasterreader.outRaster;
        rasterconverter.pOutType = this.pOutType;
        rasterconverter.pm = this.pm;
        rasterconverter.doProcess = this.doProcess;
        rasterconverter.doReset = this.doReset;
        rasterconverter.process();
        this.dumpRaster(rasterconverter.outRaster, this.outRaster);
    }

    public static void main(String[] args) throws Exception {
        RasterConverter _rasterconverter = new RasterConverter();
        _rasterconverter.inRaster = "/home/hydrologis/TMP/PITFILLE/DTM_calvello/dtm_all.asc";
        _rasterconverter.pOutType = "INTEGER";
        _rasterconverter.outRaster = "/home/hydrologis/TMP/PITFILLE/DTM_calvello/dtm_all_int.tiff";
        _rasterconverter.process();
    }
}

