/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rastercorrector.OmsRasterCorrector;

@Description(value="Raster corrector module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Correct, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="_rcorrect")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterCorrector
extends HMModel {
    @Description(value="The input raster.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The values to correct as a CSV list of triplets (format is col1,row1,value1,col2,row2,value2...).")
    @UI(value="eastnorth")
    @In
    public String pCorrections;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterCorrector rastercorrector = new OmsRasterCorrector();
        rastercorrector.inRaster = this.getRaster(this.inRaster);
        rastercorrector.pCorrections = this.pCorrections;
        rastercorrector.pm = this.pm;
        rastercorrector.doProcess = this.doProcess;
        rastercorrector.doReset = this.doReset;
        rastercorrector.process();
        this.dumpRaster(rastercorrector.outRaster, this.outRaster);
    }
}

