/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rastergenerator.OmsRasterGenerator;

@Description(value="Generates a raster.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="generator, raster")
@Label(value="Raster Processing")
@Name(value="rastergenerator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class RasterGenerator
extends HMModel {
    @Description(value="The boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The resolution in x.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The value to set the raster to.")
    @In
    public double pValue = 0.0;
    @Description(value="If true, uses a random generator.")
    @In
    public boolean doRandom = false;
    @Description(value="Optional random offset.")
    @In
    public double pOffset = 0.0;
    @Description(value="Optional random scale.")
    @In
    public double pScale = 1.0;
    @Description(value="The generated raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterGenerator omsRasterGenerator = new OmsRasterGenerator();
        omsRasterGenerator.pNorth = this.pNorth;
        omsRasterGenerator.pSouth = this.pSouth;
        omsRasterGenerator.pWest = this.pWest;
        omsRasterGenerator.pEast = this.pEast;
        omsRasterGenerator.pXres = this.pXres;
        omsRasterGenerator.pYres = this.pYres;
        omsRasterGenerator.pCode = this.pCode;
        omsRasterGenerator.pValue = this.pValue;
        omsRasterGenerator.doRandom = this.doRandom;
        omsRasterGenerator.pOffset = this.pOffset;
        omsRasterGenerator.pScale = this.pScale;
        omsRasterGenerator.process();
        this.dumpRaster(omsRasterGenerator.outRaster, this.outRaster);
    }
}

