/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rasternull.OmsRasterNull;

@Description(value="Module that puts a certain value of the raster to null.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Null, Raster")
@Label(value="Raster Processing")
@Name(value="rnull")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterNull
extends HMModel {
    @Description(value="The raster to modify.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The value to set to null.")
    @In
    public Double pValue = null;
    @Description(value="The the null value to set (else it is guessed).")
    @In
    public Double pNull = null;
    @Description(value="The new raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterNull rasternull = new OmsRasterNull();
        rasternull.inRaster = this.getRaster(this.inRaster);
        rasternull.pValue = this.pValue;
        rasternull.pNull = this.pNull;
        rasternull.pm = this.pm;
        rasternull.doProcess = this.doProcess;
        rasternull.doReset = this.doReset;
        rasternull.process();
        this.dumpRaster(rasternull.outRaster, this.outRaster);
    }
}

