/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rasterreprojector.OmsRasterReprojector;

@Description(value="Module for raster reprojection.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Crs, Reprojection, Raster, OmsRasterConverter, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="_rreproject")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterReprojector
extends HMModel {
    @Description(value="The raster that has to be reprojected.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The optional X resolution to set for the output.")
    @UI(value="process_cols")
    @In
    public Double pXres = null;
    @Description(value="The optional Y resolution to set for the output.")
    @UI(value="process_rows")
    @In
    public Double pYres = null;
    @Description(value="The projection code for the target coordinate reference system (ex. EPSG:32632).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The reprojected output raster.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        OmsRasterReprojector rasterreprojector = new OmsRasterReprojector();
        rasterreprojector.inRaster = this.getRaster(this.inRaster);
        rasterreprojector.pXres = this.pXres;
        rasterreprojector.pYres = this.pYres;
        rasterreprojector.pCode = this.pCode;
        rasterreprojector.pInterpolation = this.pInterpolation;
        rasterreprojector.pm = this.pm;
        rasterreprojector.doProcess = this.doProcess;
        rasterreprojector.doReset = this.doReset;
        rasterreprojector.process();
        this.dumpRaster(rasterreprojector.outRaster, this.outRaster);
    }
}

