/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.demmanipulation.splitsubbasin.OmsSplitSubbasins;

@Description(value="A tool for labeling the subbasins of a basin. Given the Hacks number of the channel network, the subbasin up to a selected order are labeled. If Hack order 2 was selected, the subbasins of Hack order 1 and 2 and the network of the same order are extracted.")
@Author(name="Antonello Andrea, Franceschi Silvia, Rigon Riccardo, Erica Ghesla", contact="http://www.hydrologis.com")
@Keywords(value="Subbasins, Dem, Raster")
@Label(value="HortonMachine/Dem Manipulation")
@Name(value="_splitsubbasins")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class SplitSubbasins
extends HMModel {
    @Description(value="The map of flow direction.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of hack.")
    @UI(value="infile_raster")
    @In
    public String inHack = null;
    @Description(value="The maximum hack order to consider for basin split.")
    @In
    public Double pHackorder = null;
    @Description(value="The map of numbered network.")
    @UI(value="outfile")
    @In
    public String outNetnum = null;
    @Description(value="The map of subbasins.")
    @UI(value="outfile")
    @In
    public String outSubbasins = null;

    @Execute
    public void process() throws Exception {
        OmsSplitSubbasins splitsubbasins = new OmsSplitSubbasins();
        splitsubbasins.inFlow = this.getRaster(this.inFlow);
        splitsubbasins.inHack = this.getRaster(this.inHack);
        splitsubbasins.pHackorder = this.pHackorder;
        splitsubbasins.pm = this.pm;
        splitsubbasins.doProcess = this.doProcess;
        splitsubbasins.doReset = this.doReset;
        splitsubbasins.process();
        this.dumpRaster(splitsubbasins.outNetnum, this.outNetnum);
        this.dumpRaster(splitsubbasins.outSubbasins, this.outSubbasins);
    }
}

