/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.statistics.kriging.old.OmsVariogram;

@Description(value="Experimental semivariogram algorithm.")
@Author(name="Giuseppe Formetta, Francesco Adami, Silvia Franceschi", contact="")
@Keywords(value="Experimental semivariogram, OmsKriging, Hydrology")
@Label(value="HortonMachine/Statistics")
@Name(value="_variogram")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class Variogram
extends HMModel {
    @Description(value="The vector of the measurement point, containing the position of the stations.")
    @UI(value="infile_vector")
    @In
    public String inStations = null;
    @Description(value="The field of the vector of stations, defining the id.")
    @In
    public String fStationsid = null;
    @Description(value="The field of the vector of stations, defining the elevation.")
    @In
    public String fStationsZ = null;
    @Description(value="The file with the measured data, to be interpolated.")
    @In
    public HashMap<Integer, double[]> inData = null;
    @Description(value="The path to the printed file.")
    @In
    public String pPath = null;
    @Description(value="Spatial separation distance up to which point pairs are included in semivariance estimates; as a default, the length of the diagonal of the box spanning the data is divided by three.")
    @In
    public double pCutoff;
    @Description(value="The Experimental OmsVariogram.")
    @Out
    public double[][] outResult = null;

    @Execute
    public void process() throws Exception {
        OmsVariogram variogram = new OmsVariogram();
        variogram.inStations = this.getVector(this.inStations);
        variogram.fStationsid = this.fStationsid;
        variogram.fStationsZ = this.fStationsZ;
        variogram.inData = this.inData;
        variogram.pPath = this.pPath;
        variogram.pCutoff = this.pCutoff;
        variogram.pm = this.pm;
        variogram.doProcess = this.doProcess;
        variogram.doReset = this.doReset;
        variogram.process();
        this.outResult = variogram.outResult;
    }
}

