/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectoroverlayoperators.OmsVectorIntersector;

@Description(value="Vector layer intersector with maintaining of attributes.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="vector, intersect, attributes")
@Label(value="Vector Processing")
@Name(value="vectorintersctor")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class VectorIntersector
extends HMModel {
    @Description(value="The first vector map.")
    @UI(value="infile_vector")
    @In
    public String inMap1 = null;
    @Description(value="The second vector map.")
    @UI(value="infile_vector")
    @In
    public String inMap2 = null;
    @Description(value="If enabled attributes of map 1 are kept, else of map 2.")
    @In
    public boolean doKeepFirstAttributes = true;
    @Description(value="The resulting vector map.")
    @UI(value="outfile")
    @In
    public String outMap = null;

    @Execute
    public void process() throws Exception {
        OmsVectorIntersector vint = new OmsVectorIntersector();
        vint.inMap1 = this.getVector(this.inMap1);
        vint.inMap2 = this.getVector(this.inMap2);
        vint.doKeepFirstAttributes = this.doKeepFirstAttributes;
        vint.process();
        this.dumpVector(vint.outMap, this.outMap);
    }
}

