/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectortablejoiner.OmsVectorTableJoiner;

@Description(value="Module that joins attributes from one vector into another based on a common field.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Join, OmsVectorFieldRounder")
@Label(value="Vector Processing")
@Name(value="_vjoin")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorTableJoiner
extends HMModel {
    @Description(value="The vector to extend.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The dbf tabledata to merge in.")
    @In
    public HashMap<String, List<Object>> tabledata = null;
    @Description(value="The common field (if different in the two sources, commaseparated, first shapefile, then dbf.")
    @In
    public String fCommon = null;
    @Description(value="The commaseparated list of fields to merge in.")
    @In
    public String pFields = null;
    @Description(value="The joined vector.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        OmsVectorTableJoiner vectortablejoiner = new OmsVectorTableJoiner();
        vectortablejoiner.inVector = this.getVector(this.inVector);
        vectortablejoiner.tabledata = this.tabledata;
        vectortablejoiner.fCommon = this.fCommon;
        vectortablejoiner.pFields = this.pFields;
        vectortablejoiner.pm = this.pm;
        vectortablejoiner.doProcess = this.doProcess;
        vectortablejoiner.doReset = this.doReset;
        vectortablejoiner.process();
        this.dumpVector(vectortablejoiner.outVector, this.outVector);
    }
}

