/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.elresolver;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.Manifest;
import org.hotswap.agent.annotation.Maven;
import org.hotswap.agent.annotation.Name;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.annotation.Versions;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.elresolver.PurgeBeanELResolverCacheCommand;
import org.hotswap.agent.plugin.elresolver.PurgeJbossReflectionUtil;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="ELResolver", group="groupELResolver", fallback=true, description="Purge BeanELResolver class cache on any class redefinition.", testedVersions={"2.2"}, expectedVersions={"2.2"})
@Versions(maven={@Maven(value="[1.0,)", artifactId="jboss-el-api_2.2_spec", groupId="org.jboss.spec.javax.el"), @Maven(value="[2.0,)", artifactId="juel", groupId="de.odysseus.juel"), @Maven(value="[3.0,)", artifactId="javax.el-api", groupId="javax.el")}, manifest={@Manifest(value="[1.0,)", versionName={"JBoss-EL-Version"}, names={@Name(key="JBoss-EL-Version", value=".*")}), @Manifest(value="[2.0,)", versionName={"Specification-Version"}, names={@Name(key="Implementation-Title", value="javax.el"), @Name(key="Implementation-Vendor", value="Apache.*Software.*Foundation")}), @Manifest(value="[2.0,)", versionName={"Bundle-Version"}, names={@Name(key="Bundle-SymbolicName", value="javax.el")}), @Manifest(value="[8.0,)", versionName={"Bundle-Version"}, names={@Name(key="Bundle-SymbolicName", value="org.mortbay.jasper.apache-el"), @Name(key="Bundle-Vendor", value="Webtide")}), @Manifest(value="[3.0,)", versionName={"Bundle-Version"}, names={@Name(key="Bundle-SymbolicName", value="com.sun.el.javax.el"), @Name(key="Bundle-Vendor", value="GlassFish Community")})})
public class ELResolverPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ELResolverPlugin.class);
    public static final String PURGE_CLASS_CACHE_METHOD_NAME = "$$ha$resetCache";
    @Init
    Scheduler scheduler;
    Set<Object> registeredBeanELResolvers = Collections.newSetFromMap(new WeakHashMap());
    boolean jbossReflectionUtil = false;

    public void registerJBossReflectionUtil() {
        this.jbossReflectionUtil = true;
    }

    @Init
    public void init(PluginConfiguration pluginConfiguration) {
        LOGGER.info("ELResolver plugin initialized.", new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp="javax.el.BeanELResolver")
    public static void beanELResolverRegisterVariable(CtClass ctClass) throws CannotCompileException {
        String initPlugin = PluginManagerInvoker.buildInitializePlugin(ELResolverPlugin.class);
        String registerThis = PluginManagerInvoker.buildCallPluginMethod(ELResolverPlugin.class, (String)"registerBeanELResolver", (String[])new String[]{"this", "java.lang.Object"});
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(initPlugin);
            constructor.insertAfter(registerThis);
        }
        boolean found = false;
        if (ELResolverPlugin.checkJuelEL(ctClass)) {
            found = true;
            LOGGER.debug("JuelEL - javax.el.BeanELResolver - method added $$ha$resetCache(java.lang.ClassLoader classLoader). ", new Object[0]);
        } else if (ELResolverPlugin.checkApacheEL(ctClass)) {
            found = true;
            LOGGER.debug("ApacheEL - javax.el.BeanELResolver - method added $$ha$resetCache(java.lang.ClassLoader classLoader). ", new Object[0]);
        } else if (ELResolverPlugin.checkJBoss_3_0_EL(ctClass)) {
            found = true;
            LOGGER.debug("JBossEL 3.0 - javax.el.BeanELResolver - method added $$ha$resetCache(java.lang.ClassLoader classLoader). ", new Object[0]);
        }
        if (!found) {
            LOGGER.warning("Unable to add javax.el.BeanELResolver.$$ha$resetCache() method. Purging will not be available.", new Object[0]);
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.jboss.el.util.ReflectionUtil")
    public static void patchJBossReflectionUtil(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtField ctField = new CtField(CtClass.booleanType, "$$ha$haInitialized", ctClass);
        ctField.setModifiers(10);
        ctClass.addField(ctField, CtField.Initializer.constant((boolean)false));
        String buildInitializePlugin = PluginManagerInvoker.buildInitializePlugin(ELResolverPlugin.class, (String)"base.getClass().getClassLoader()");
        String registerJBossReflectionUtil = PluginManagerInvoker.buildCallPluginMethod((String)"base.getClass().getClassLoader()", ELResolverPlugin.class, (String)"registerJBossReflectionUtil", (String[])new String[0]);
        CtMethod mFindMethod = ctClass.getDeclaredMethod("findMethod");
        mFindMethod.insertAfter("if(!$$ha$haInitialized) {$$ha$haInitialized=true;" + buildInitializePlugin + registerJBossReflectionUtil + "}");
        LOGGER.debug("org.jboss.el.util.ReflectionUtil enhanced with resource bundles registration.", new Object[0]);
    }

    private static boolean checkJuelEL(CtClass ctClass) {
        try {
            CtMethod purgeMeth = ctClass.getDeclaredMethod("purgeBeanClasses");
            ctClass.addMethod(CtNewMethod.make((String)"public void $$ha$resetCache(java.lang.ClassLoader classLoader) {purgeBeanClasses(classLoader);}", (CtClass)ctClass));
            return true;
        }
        catch (CannotCompileException | NotFoundException throwable) {
            return false;
        }
    }

    private static boolean checkApacheEL(CtClass ctClass) {
        try {
            CtField field = ctClass.getField("cache");
            ctClass.addField(new CtField(CtClass.booleanType, "$$ha$purgeRequested", ctClass), CtField.Initializer.constant((boolean)false));
            ctClass.addMethod(CtNewMethod.make((String)"public void $$ha$resetCache(java.lang.ClassLoader classLoader) {$$ha$purgeRequested=true;}", (CtClass)ctClass));
            CtMethod mGetBeanProperty = ctClass.getDeclaredMethod("property");
            mGetBeanProperty.insertBefore("if($$ha$purgeRequested) {$$ha$purgeRequested=false;this.cache = new javax.el.BeanELResolver.ConcurrentCache(CACHE_SIZE); }");
            return true;
        }
        catch (NotFoundException notFoundException) {
        }
        catch (CannotCompileException cannotCompileException) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkJBoss_3_0_EL(CtClass ctClass) {
        try {
            CtField field = ctClass.getField("properties");
            if ((field.getModifiers() & 8) != 0) {
                field.setModifiers(8);
                ELResolverPlugin.patchJBossEl(ctClass);
            }
            return true;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    private static void patchJBossEl(CtClass ctClass) {
        try {
            ctClass.addField(new CtField(CtClass.booleanType, "$$ha$purgeRequested", ctClass), CtField.Initializer.constant((boolean)false));
            ctClass.addMethod(CtNewMethod.make((String)"public void $$ha$resetCache(java.lang.ClassLoader classLoader) {$$ha$purgeRequested=true;}", (CtClass)ctClass));
            try {
                CtMethod mGetBeanProperty = ctClass.getDeclaredMethod("getBeanProperty");
                mGetBeanProperty.insertBefore("if($$ha$purgeRequested) {$$ha$purgeRequested=false;java.lang.reflect.Method meth = javax.el.BeanELResolver.SoftConcurrentHashMap.class.getDeclaredMethod(\"$$ha$createNewInstance\", null);properties = (javax.el.BeanELResolver.SoftConcurrentHashMap) meth.invoke(properties, null);}");
            }
            catch (NotFoundException e) {
                LOGGER.debug("FIXME : checkJBoss_3_0_EL() 'getBeanProperty(...)' not found in javax.el.BeanELResolver.", new Object[0]);
            }
        }
        catch (CannotCompileException e) {
            LOGGER.error("patchJBossEl() exception {}", new Object[]{e.getMessage()});
        }
    }

    @OnClassLoadEvent(classNameRegexp="javax.el.BeanELResolver\\$SoftConcurrentHashMap")
    public static void patchJbossElSoftConcurrentHashMap(CtClass ctClass) throws CannotCompileException {
        try {
            ctClass.addMethod(CtNewMethod.make((String)"public javax.el.BeanELResolver.SoftConcurrentHashMap $$ha$createNewInstance() {return new javax.el.BeanELResolver.SoftConcurrentHashMap();}", (CtClass)ctClass));
        }
        catch (CannotCompileException e) {
            LOGGER.error("patchJbossElSoftConcurrentHashMap() exception {}", new Object[]{e.getMessage()});
        }
    }

    public void registerBeanELResolver(Object beanELResolver) {
        this.registeredBeanELResolvers.add(beanELResolver);
        LOGGER.debug("ELResolverPlugin - BeanELResolver registered : " + beanELResolver.getClass().getName(), new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void invalidateClassCache(ClassLoader appClassLoader, CtClass ctClass) throws Exception {
        if (this.jbossReflectionUtil) {
            PurgeJbossReflectionUtil jbossCleanCmd = new PurgeJbossReflectionUtil(appClassLoader);
            this.scheduler.scheduleCommand((Command)jbossCleanCmd);
        }
        PurgeBeanELResolverCacheCommand cmd = new PurgeBeanELResolverCacheCommand(appClassLoader, this.registeredBeanELResolvers);
        this.scheduler.scheduleCommand((Command)cmd);
    }
}

