/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.hibernate.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.Version;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;

public class EntityManagerFactoryProxy {
    private static AgentLogger LOGGER = AgentLogger.getLogger(EntityManagerFactoryProxy.class);
    private static Map<String, EntityManagerFactoryProxy> proxiedFactories = new HashMap<String, EntityManagerFactoryProxy>();
    final Object reloadLock = new Object();
    EntityManagerFactory currentInstance;
    String persistenceUnitName;
    PersistenceUnitInfo info;
    Map properties;
    Object builder;

    public static EntityManagerFactoryProxy getWrapper(String persistenceUnitName) {
        if (!proxiedFactories.containsKey(persistenceUnitName)) {
            proxiedFactories.put(persistenceUnitName, new EntityManagerFactoryProxy());
        }
        return proxiedFactories.get(persistenceUnitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshProxiedFactories() {
        Object[] version = Version.getVersionString().split("\\.");
        boolean version43OrGreater = false;
        try {
            version43OrGreater = Integer.valueOf(version[0]) >= 5 || Integer.valueOf((String)version[0]) == 4 && Integer.valueOf((String)version[1]) >= 3;
        }
        catch (Exception e) {
            LOGGER.warning("Unable to resolve hibernate version '{}'", version);
        }
        for (EntityManagerFactoryProxy wrapper : proxiedFactories.values()) {
            String persistenceClassName = wrapper.properties == null ? null : (String)wrapper.properties.get("PERSISTENCE_CLASS_NAME");
            try {
                Object object = wrapper.reloadLock;
                synchronized (object) {
                    if ("org.springframework.orm.jpa.vendor.SpringHibernateJpaPersistenceProvider".equals(persistenceClassName)) {
                        wrapper.refreshProxiedFactorySpring();
                    } else if (version43OrGreater) {
                        wrapper.refreshProxiedFactoryVersion43OrGreater();
                    } else {
                        wrapper.refreshProxiedFactory();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void refreshProxiedFactorySpring() {
        try {
            this.currentInstance = (EntityManagerFactory)ReflectionHelper.invoke((Object)this.builder, this.builder.getClass(), (String)"createContainerEntityManagerFactory", (Class[])new Class[]{PersistenceUnitInfo.class, Map.class}, (Object[])new Object[]{this.info, this.properties});
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Unable to reload persistence unit {}", new Object[]{this.info, e});
        }
    }

    public void refreshProxiedFactoryVersion43OrGreater() {
        if (this.info == null) {
            this.currentInstance = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, (Map)this.properties);
        } else {
            try {
                Class bootstrapClazz = this.loadClass("org.hibernate.jpa.boot.spi.Bootstrap");
                Class builderClazz = this.loadClass("org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder");
                Object builder = ReflectionHelper.invoke(null, (Class)bootstrapClazz, (String)"getEntityManagerFactoryBuilder", (Class[])new Class[]{PersistenceUnitInfo.class, Map.class}, (Object[])new Object[]{this.info, this.properties});
                this.currentInstance = (EntityManagerFactory)ReflectionHelper.invoke((Object)builder, (Class)builderClazz, (String)"build", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Unable to reload persistence unit {}", new Object[]{this.info, e});
            }
        }
    }

    public void refreshProxiedFactory() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        try {
            Class entityManagerFactoryRegistryClazz = this.loadClass("org.hibernate.ejb.internal.EntityManagerFactoryRegistry");
            Object instance = ReflectionHelper.get(null, (Class)entityManagerFactoryRegistryClazz, (String)"INSTANCE");
            ReflectionHelper.invoke((Object)instance, (Class)entityManagerFactoryRegistryClazz, (String)"removeEntityManagerFactory", (Class[])new Class[]{String.class, EntityManagerFactory.class}, (Object[])new Object[]{this.persistenceUnitName, this.currentInstance});
        }
        catch (Exception e) {
            LOGGER.error("Unable to clear previous instance of entity manager factory", new Object[0]);
        }
        this.buildFreshEntityManagerFactory();
    }

    private void buildFreshEntityManagerFactory() {
        try {
            Class ejb3ConfigurationClazz = this.loadClass("org.hibernate.ejb.Ejb3Configuration");
            LOGGER.trace("new Ejb3Configuration()", new Object[0]);
            Object cfg = ejb3ConfigurationClazz.newInstance();
            LOGGER.trace("cfg.configure( info, properties );", new Object[0]);
            if (this.info != null) {
                ReflectionHelper.invoke(cfg, (Class)ejb3ConfigurationClazz, (String)"configure", (Class[])new Class[]{PersistenceUnitInfo.class, Map.class}, (Object[])new Object[]{this.info, this.properties});
            } else {
                ReflectionHelper.invoke(cfg, (Class)ejb3ConfigurationClazz, (String)"configure", (Class[])new Class[]{String.class, Map.class}, (Object[])new Object[]{this.persistenceUnitName, this.properties});
            }
            LOGGER.trace("configured.buildEntityManagerFactory()", new Object[0]);
            this.currentInstance = (EntityManagerFactory)ReflectionHelper.invoke(cfg, (Class)ejb3ConfigurationClazz, (String)"buildEntityManagerFactory", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to build fresh entity manager factory for persistence unit {}", new Object[]{this.persistenceUnitName});
        }
    }

    public EntityManagerFactory proxy(Object builder, EntityManagerFactory factory, String persistenceUnitName, PersistenceUnitInfo info, Map properties) {
        this.builder = builder;
        this.currentInstance = factory;
        this.persistenceUnitName = persistenceUnitName;
        this.info = info;
        this.properties = properties;
        return (EntityManagerFactory)Proxy.newProxyInstance(this.currentInstance.getClass().getClassLoader(), this.currentInstance.getClass().getInterfaces(), new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object object = EntityManagerFactoryProxy.this.reloadLock;
                synchronized (object) {
                }
                return method.invoke((Object)EntityManagerFactoryProxy.this.currentInstance, args);
            }
        });
    }

    private Class loadClass(String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }
}

