/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.javabeans;

import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;

@Plugin(name="JavaBeans", description="", testedVersions={"openjdk 1.7.0.95, 1.8.0_74"}, expectedVersions={"All between openjdk 1.7 - 1.8"})
public class JavaBeansPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(JavaBeansPlugin.class);
    public static boolean reloadFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public static void flushBeanIntrospectorsCaches(ClassLoader classLoader, CtClass ctClass) {
        try {
            Object declaredMethodCache;
            LOGGER.debug("Flushing {}", new Object[]{ctClass.getName()});
            Class<?> clazz = classLoader.loadClass(ctClass.getName());
            Class<?> threadGroupCtxClass = classLoader.loadClass("java.beans.ThreadGroupContext");
            Class<?> introspectorClass = classLoader.loadClass("java.beans.Introspector");
            Object object = declaredMethodCache = ReflectionHelper.get(null, introspectorClass, (String)"declaredMethodCache");
            synchronized (object) {
                Object contexts = ReflectionHelper.get(null, threadGroupCtxClass, (String)"contexts");
                Object[] table = (Object[])ReflectionHelper.get((Object)contexts, (String)"table");
                if (table != null) {
                    for (Object o : table) {
                        Object threadGroupContext;
                        if (o == null || (threadGroupContext = ReflectionHelper.get((Object)o, (String)"value")) == null) continue;
                        LOGGER.trace("Removing from threadGroupContext", new Object[0]);
                        ReflectionHelper.invoke((Object)threadGroupContext, threadGroupCtxClass, (String)"removeBeanInfo", (Class[])new Class[]{Class.class}, (Object[])new Object[]{clazz});
                    }
                }
                LOGGER.trace("Removing class from declaredMethodCache.", new Object[0]);
                ReflectionHelper.invoke((Object)declaredMethodCache, declaredMethodCache.getClass(), (String)"put", (Class[])new Class[]{Object.class, Object.class}, (Object[])new Object[]{clazz, null});
            }
        }
        catch (Exception e) {
            LOGGER.error("classReload() exception {}.", new Object[]{e.getMessage()});
        }
        finally {
            reloadFlag = false;
        }
    }
}

