/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.Modifier;
import org.hotswap.agent.plugin.proxy.ProxyBytecodeTransformer;

public abstract class AbstractProxyBytecodeTransformer
implements ProxyBytecodeTransformer {
    private ClassPool classPool;

    public AbstractProxyBytecodeTransformer(ClassPool classPool) {
        this.classPool = classPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(byte[] byteCode) throws Exception {
        CtClass cc = this.classPool.makeClass((InputStream)new ByteArrayInputStream(byteCode), false);
        try {
            String initFieldName = "initCalled" + this.generateRandomString();
            this.addStaticInitStateField(cc, initFieldName);
            String initCode = this.getInitCall(cc, initFieldName);
            this.addInitCallToMethods(cc, initFieldName, initCode);
            byte[] byArray = cc.toBytecode();
            return byArray;
        }
        finally {
            cc.detach();
        }
    }

    protected abstract String getInitCall(CtClass var1, String var2) throws Exception;

    protected String generateRandomString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    protected void addInitCallToMethods(CtClass cc, String clinitFieldName, String initCall) throws Exception {
        CtMethod[] methods;
        for (CtMethod ctMethod : methods = cc.getDeclaredMethods()) {
            if (ctMethod.isEmpty() || Modifier.isStatic((int)ctMethod.getModifiers())) continue;
            ctMethod.insertBefore("if(!" + clinitFieldName + "){synchronized(" + cc.getName() + ".class){if(!" + clinitFieldName + "){" + initCall + "}}}");
        }
    }

    protected void addStaticInitStateField(CtClass cc, String clinitFieldName) throws Exception {
        CtField f = new CtField(CtClass.booleanType, clinitFieldName, cc);
        f.setModifiers(10);
        cc.addField(f, "true");
    }
}

