/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy;

import java.util.Map;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.AbstractProxyTransformer;
import org.hotswap.agent.plugin.proxy.ProxyBytecodeGenerator;
import org.hotswap.agent.plugin.proxy.ProxyBytecodeTransformer;
import org.hotswap.agent.plugin.proxy.RedefinitionScheduler;
import org.hotswap.agent.plugin.proxy.TransformationState;

public abstract class MultistepProxyTransformer
extends AbstractProxyTransformer {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(MultistepProxyTransformer.class);
    public static boolean addThirdStep = false;
    protected byte[] classfileBuffer;
    protected Map<Class<?>, TransformationState> transformationStates;
    protected ProxyBytecodeGenerator generator;
    protected ProxyBytecodeTransformer transformer;

    public MultistepProxyTransformer(Class<?> classBeingRedefined, ClassPool classPool, byte[] classfileBuffer, Map<Class<?>, TransformationState> transformationStates) {
        super(classBeingRedefined, classPool);
        this.classPool = classPool;
        this.transformationStates = transformationStates;
        this.classfileBuffer = classfileBuffer;
    }

    @Override
    public byte[] transformRedefine() throws Exception {
        switch (this.getTransformationstate()) {
            case NEW: {
                if (!this.isTransformingNeeded()) {
                    return this.classfileBuffer;
                }
                this.setClassAsWaiting();
                this.scheduleRedefinition();
                return this.classfileBuffer;
            }
            case WAITING: {
                this.classfileBuffer = this.getTransformer().transform(this.getGenerator().generate());
                LOGGER.reload("Class '{}' has been reloaded.", new Object[]{this.classBeingRedefined.getName()});
                if (addThirdStep) {
                    this.setClassAsFinished();
                    this.scheduleRedefinition();
                } else {
                    this.removeClassState();
                }
                return this.classfileBuffer;
            }
            case FINISHED: {
                this.removeClassState();
                return this.classfileBuffer;
            }
        }
        throw new RuntimeException("Unhandeled TransformationState!");
    }

    protected TransformationState getTransformationstate() {
        TransformationState transformationState = this.transformationStates.get(this.classBeingRedefined);
        if (transformationState == null) {
            transformationState = TransformationState.NEW;
        }
        return transformationState;
    }

    protected void scheduleRedefinition() {
        RedefinitionScheduler.schedule(this);
    }

    protected TransformationState setClassAsWaiting() {
        return this.transformationStates.put(this.classBeingRedefined, TransformationState.WAITING);
    }

    protected TransformationState setClassAsFinished() {
        return this.transformationStates.put(this.classBeingRedefined, TransformationState.FINISHED);
    }

    protected TransformationState removeClassState() {
        return this.transformationStates.remove(this.classBeingRedefined);
    }

    public Class<?> getClassBeingRedefined() {
        return this.classBeingRedefined;
    }

    public byte[] getClassfileBuffer() {
        return this.classfileBuffer;
    }
}

