/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.hscglib;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.hotswap.agent.plugin.proxy.ParentLastClassLoader;
import org.hotswap.agent.plugin.proxy.ProxyBytecodeGenerator;
import org.hotswap.agent.plugin.proxy.hscglib.GeneratorParams;
import org.hotswap.agent.util.ReflectionHelper;

public class CglibEnhancerProxyBytecodeGenerator
implements ProxyBytecodeGenerator {
    private GeneratorParams param;
    private ClassLoader classLoader;
    private Class<?> generatorClass;
    private Object generator;
    private Class<?> abstractGeneratorClass;

    public CglibEnhancerProxyBytecodeGenerator(GeneratorParams param, ClassLoader classLoader) {
        this.param = param;
        this.classLoader = new ParentLastClassLoader(classLoader);
        this.generator = param.getParam();
        this.generatorClass = this.generator.getClass();
        this.abstractGeneratorClass = this.generatorClass.getSuperclass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generate() throws Exception {
        Collection<FieldState> oldClassValues = this.getFieldValuesWithClasses();
        ClassLoader oldClassLoader = (ClassLoader)ReflectionHelper.get((Object)this.generator, (String)"classLoader");
        Boolean oldUseCache = (Boolean)ReflectionHelper.get((Object)this.generator, (String)"useCache");
        try {
            byte[] invoke;
            ReflectionHelper.set((Object)this.generator, this.abstractGeneratorClass, (String)"classLoader", (Object)this.classLoader);
            ReflectionHelper.set((Object)this.generator, this.abstractGeneratorClass, (String)"useCache", (Object)Boolean.FALSE);
            this.setFieldValuesWithNewLoadedClasses(oldClassValues);
            byte[] byArray = invoke = (byte[])ReflectionHelper.invoke((Object)this.param.getGenerator(), this.param.getGenerator().getClass(), (String)"generate", (Class[])new Class[]{this.getGeneratorInterfaceClass()}, (Object[])new Object[]{this.generator});
            return byArray;
        }
        finally {
            ReflectionHelper.set((Object)this.generator, this.abstractGeneratorClass, (String)"classLoader", (Object)oldClassLoader);
            ReflectionHelper.set((Object)this.generator, this.abstractGeneratorClass, (String)"useCache", (Object)oldUseCache);
            this.setFieldValues(oldClassValues);
        }
    }

    private Class<?> getGeneratorInterfaceClass() {
        Class<?>[] interfaces;
        for (Class<?> iClass : interfaces = this.abstractGeneratorClass.getInterfaces()) {
            if (!iClass.getName().endsWith(".ClassGenerator")) continue;
            return iClass;
        }
        return null;
    }

    private void setFieldValues(Collection<FieldState> fieldStates) throws IllegalAccessException {
        for (FieldState fieldState : fieldStates) {
            fieldState.field.set(this.generator, fieldState.fieldValue);
        }
    }

    private void setFieldValuesWithNewLoadedClasses(Collection<FieldState> fieldStates) throws IllegalAccessException, ClassNotFoundException {
        for (FieldState fieldState : fieldStates) {
            fieldState.field.set(this.generator, this.loadFromClassloader(fieldState.fieldValue));
        }
    }

    private Collection<FieldState> getFieldValuesWithClasses() throws IllegalAccessException {
        Field[] fields;
        ArrayList<FieldState> classValueFields = new ArrayList<FieldState>();
        for (Field field : fields = this.generatorClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !field.getType().isInstance(Class.class) && !field.getType().isInstance(Class[].class)) continue;
            field.setAccessible(true);
            classValueFields.add(new FieldState(field, field.get(this.generator)));
        }
        return classValueFields;
    }

    private Object loadFromClassloader(Object fieldState) throws ClassNotFoundException {
        if (fieldState instanceof Class[]) {
            Class[] classes = (Class[])fieldState;
            Class[] newClasses = new Class[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                Class<?> loadClass;
                newClasses[i] = loadClass = this.classLoader.loadClass(classes[i].getName());
            }
            return newClasses;
        }
        return this.classLoader.loadClass(((Class)fieldState).getName());
    }

    private static class FieldState {
        private Field field;
        private Object fieldValue;

        public FieldState(Field field, Object fieldValue) {
            this.field = field;
            this.fieldValue = fieldValue;
        }
    }
}

