/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.hotswap.agent.logging.AgentLogger;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ResetBeanPostProcessorCaches {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ResetBeanPostProcessorCaches.class);

    private static Class<?> getReflectionUtilsClassOrNull() {
        try {
            return Class.forName("org.springframework.util.ReflectionUtils");
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Spring 4.1.x or below - ReflectionUtils class not found", new Object[0]);
            return null;
        }
    }

    public static void reset(DefaultListableBeanFactory beanFactory) {
        Class<?> c = ResetBeanPostProcessorCaches.getReflectionUtilsClassOrNull();
        if (c != null) {
            try {
                Method m = c.getDeclaredMethod("clearCache", new Class[0]);
                m.invoke(c, new Object[0]);
            }
            catch (Exception version42Failed) {
                try {
                    Field declaredMethodsCache = c.getDeclaredField("declaredMethodsCache");
                    declaredMethodsCache.setAccessible(true);
                    ((Map)declaredMethodsCache.get(null)).clear();
                    Field declaredFieldsCache = c.getDeclaredField("declaredFieldsCache");
                    declaredFieldsCache.setAccessible(true);
                    ((Map)declaredFieldsCache.get(null)).clear();
                }
                catch (Exception version40Failed) {
                    LOGGER.debug("Failed to clear internal method/field cache, it's normal with spring 4.1x or lower", (Throwable)version40Failed, new Object[0]);
                }
            }
            LOGGER.trace("Cleared Spring 4.2+ internal method/field cache.", new Object[0]);
        }
        for (BeanPostProcessor bpp : beanFactory.getBeanPostProcessors()) {
            if (bpp instanceof AutowiredAnnotationBeanPostProcessor) {
                ResetBeanPostProcessorCaches.resetAutowiredAnnotationBeanPostProcessorCache((AutowiredAnnotationBeanPostProcessor)bpp);
                continue;
            }
            if (!(bpp instanceof InitDestroyAnnotationBeanPostProcessor)) continue;
            ResetBeanPostProcessorCaches.resetInitDestroyAnnotationBeanPostProcessorCache((InitDestroyAnnotationBeanPostProcessor)bpp);
        }
    }

    public static void resetInitDestroyAnnotationBeanPostProcessorCache(InitDestroyAnnotationBeanPostProcessor bpp) {
        try {
            Field field = InitDestroyAnnotationBeanPostProcessor.class.getDeclaredField("lifecycleMetadataCache");
            field.setAccessible(true);
            Map lifecycleMetadataCache = (Map)field.get(bpp);
            lifecycleMetadataCache.clear();
            LOGGER.trace("Cache cleared: InitDestroyAnnotationBeanPostProcessor.lifecycleMetadataCache", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear InitDestroyAnnotationBeanPostProcessor.lifecycleMetadataCache", e);
        }
    }

    public static void resetAutowiredAnnotationBeanPostProcessorCache(AutowiredAnnotationBeanPostProcessor bpp) {
        Field field;
        try {
            field = AutowiredAnnotationBeanPostProcessor.class.getDeclaredField("candidateConstructorsCache");
            field.setAccessible(true);
            Map candidateConstructorsCache = (Map)field.get(bpp);
            candidateConstructorsCache.clear();
            LOGGER.debug("Cache cleared: AutowiredAnnotationBeanPostProcessor.candidateConstructorsCache", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear AutowiredAnnotationBeanPostProcessor.candidateConstructorsCache", e);
        }
        try {
            field = AutowiredAnnotationBeanPostProcessor.class.getDeclaredField("injectionMetadataCache");
            field.setAccessible(true);
            Map injectionMetadataCache = (Map)field.get(bpp);
            injectionMetadataCache.clear();
            LOGGER.debug("Cache cleared: AutowiredAnnotationBeanPostProcessor.injectionMetadataCache", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear AutowiredAnnotationBeanPostProcessor.injectionMetadataCache", e);
        }
    }
}

