/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring;

import java.lang.reflect.Field;
import java.util.Map;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class ResetSpringStaticCaches {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ResetSpringStaticCaches.class);

    public static void resetBeanNamesByType(DefaultListableBeanFactory defaultListableBeanFactory) {
        Field field;
        try {
            field = DefaultListableBeanFactory.class.getDeclaredField("singletonBeanNamesByType");
            field.setAccessible(true);
            Map singletonBeanNamesByType = (Map)field.get(defaultListableBeanFactory);
            singletonBeanNamesByType.clear();
        }
        catch (Exception e) {
            LOGGER.trace("Unable to clear DefaultListableBeanFactory.singletonBeanNamesByType cache (is Ok for pre 3.1.2 Spring version)", (Throwable)e, new Object[0]);
        }
        try {
            field = DefaultListableBeanFactory.class.getDeclaredField("allBeanNamesByType");
            field.setAccessible(true);
            Map allBeanNamesByType = (Map)field.get(defaultListableBeanFactory);
            allBeanNamesByType.clear();
        }
        catch (Exception e) {
            LOGGER.trace("Unable to clear allBeanNamesByType cache (is Ok for pre 3.2 Spring version)", new Object[0]);
        }
        try {
            field = DefaultListableBeanFactory.class.getDeclaredField("nonSingletonBeanNamesByType");
            field.setAccessible(true);
            Map nonSingletonBeanNamesByType = (Map)field.get(defaultListableBeanFactory);
            nonSingletonBeanNamesByType.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Unable to clear nonSingletonBeanNamesByType cache (is Ok for pre 3.2 Spring version)", new Object[0]);
        }
    }

    public static void reset() {
        ResetSpringStaticCaches.resetTypeVariableCache();
        ResetSpringStaticCaches.resetAnnotationUtilsCache();
        ResetSpringStaticCaches.resetReflectionUtilsCache();
        ResetSpringStaticCaches.resetResolvableTypeCache();
        ResetSpringStaticCaches.resetPropetyCache();
        CachedIntrospectionResults.clearClassLoader((ClassLoader)ResetSpringStaticCaches.class.getClassLoader());
    }

    private static void resetResolvableTypeCache() {
        ReflectionHelper.invokeNoException(null, (String)"org.springframework.core.ResolvableType", (ClassLoader)ResetSpringStaticCaches.class.getClassLoader(), (String)"clearCache", (Class[])new Class[0], (Object[])new Object[0]);
    }

    private static void resetTypeVariableCache() {
        try {
            Field field = GenericTypeResolver.class.getDeclaredField("typeVariableCache");
            field.setAccessible(true);
            Map typeVariableCache = (Map)field.get(null);
            typeVariableCache.clear();
            LOGGER.trace("Cache cleared: GenericTypeResolver.typeVariableCache", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear GenericTypeResolver.typeVariableCache", e);
        }
    }

    private static void resetReflectionUtilsCache() {
        ReflectionHelper.invokeNoException(null, (String)"org.springframework.util.ReflectionUtils", (ClassLoader)ResetSpringStaticCaches.class.getClassLoader(), (String)"clearCache", (Class[])new Class[0], (Object[])new Object[0]);
        Map declaredMethodsCache = (Map)ReflectionHelper.getNoException(null, ReflectionUtils.class, (String)"declaredMethodsCache");
        if (declaredMethodsCache != null) {
            declaredMethodsCache.clear();
            LOGGER.trace("Cache cleared: ReflectionUtils.declaredMethodsCache", new Object[0]);
        } else {
            LOGGER.trace("Cache NOT cleared: ReflectionUtils.declaredMethodsCache not exists", new Object[0]);
        }
    }

    private static void resetAnnotationUtilsCache() {
        ReflectionHelper.invokeNoException(null, (String)"org.springframework.core.annotation.AnnotationUtils", (ClassLoader)ResetSpringStaticCaches.class.getClassLoader(), (String)"clearCache", (Class[])new Class[0], (Object[])new Object[0]);
        Map annotatedInterfaceCache = (Map)ReflectionHelper.getNoException(null, AnnotationUtils.class, (String)"annotatedInterfaceCache");
        if (annotatedInterfaceCache != null) {
            annotatedInterfaceCache.clear();
            LOGGER.trace("Cache cleared: AnnotationUtils.annotatedInterfaceCache", new Object[0]);
        } else {
            LOGGER.trace("Cache NOT cleared: AnnotationUtils.annotatedInterfaceCache not exists in target Spring verion (pre 3.1.x)", new Object[0]);
        }
        Map findAnnotationCache = (Map)ReflectionHelper.getNoException(null, AnnotationUtils.class, (String)"findAnnotationCache");
        if (findAnnotationCache != null) {
            findAnnotationCache.clear();
            LOGGER.trace("Cache cleared: AnnotationUtils.findAnnotationCache", new Object[0]);
        } else {
            LOGGER.trace("Cache NOT cleared: AnnotationUtils.findAnnotationCache not exists in target Spring version (pre 4.1)", new Object[0]);
        }
    }

    private static void resetPropetyCache() {
        try {
            ClassLoader classLoader = ResetSpringStaticCaches.class.getClassLoader();
            Map annotationCache = (Map)ReflectionHelper.get(null, classLoader.loadClass("org.springframework.core.convert.Property"), (String)"annotationCache");
            annotationCache.clear();
            LOGGER.trace("Cache cleared: Property.annotationCache", new Object[0]);
        }
        catch (Exception e) {
            LOGGER.trace("Unable to clear Property.annotationCache (ok before Spring 3.2.x)", (Throwable)e, new Object[0]);
        }
    }
}

