/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring;

import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URI;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.SpringChangesAnalyzer;
import org.hotswap.agent.plugin.spring.getbean.ProxyReplacerTransformer;
import org.hotswap.agent.plugin.spring.scanner.ClassPathBeanDefinitionScannerTransformer;
import org.hotswap.agent.plugin.spring.scanner.ClassPathBeanRefreshCommand;
import org.hotswap.agent.plugin.spring.scanner.XmlBeanDefinitionScannerTransformer;
import org.hotswap.agent.plugin.spring.scanner.XmlBeanRefreshCommand;
import org.hotswap.agent.util.HaClassFileTransformer;
import org.hotswap.agent.util.HotswapTransformer;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.classloader.ClassLoaderHelper;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;
import org.hotswap.agent.watch.Watcher;

@Plugin(name="Spring", description="Reload Spring configuration after class definition/change.", testedVersions={"All between 3.0.1 - 5.2.2"}, expectedVersions={"3x", "4x", "5x"}, supportClass={ClassPathBeanDefinitionScannerTransformer.class, ProxyReplacerTransformer.class, XmlBeanDefinitionScannerTransformer.class})
public class SpringPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(SpringPlugin.class);
    private static final int WAIT_ON_CREATE = 600;
    public static String[] basePackagePrefixes;
    @Init
    HotswapTransformer hotswapTransformer;
    @Init
    Watcher watcher;
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;

    public void init() {
        LOGGER.info("Spring plugin initialized", new Object[0]);
        this.registerBasePackageFromConfiguration();
        this.initBasePackagePrefixes();
    }

    public void init(String version) {
        LOGGER.info("Spring plugin initialized - Spring core version '{}'", new Object[]{version});
        this.registerBasePackageFromConfiguration();
        this.initBasePackagePrefixes();
    }

    private void initBasePackagePrefixes() {
        PluginConfiguration pluginConfiguration = new PluginConfiguration(this.appClassLoader);
        if (basePackagePrefixes == null || basePackagePrefixes.length == 0) {
            basePackagePrefixes = pluginConfiguration.getBasePackagePrefixes();
        } else {
            String[] newBasePackagePrefixes = pluginConfiguration.getBasePackagePrefixes();
            ArrayList both = new ArrayList(basePackagePrefixes.length + newBasePackagePrefixes.length);
            Collections.addAll(both, basePackagePrefixes);
            Collections.addAll(both, newBasePackagePrefixes);
            basePackagePrefixes = both.toArray(new String[both.size()]);
        }
    }

    @OnResourceFileEvent(path="/", filter=".*.xml", events={FileEvent.MODIFY})
    public void registerResourceListeners(URL url) {
        this.scheduler.scheduleCommand((Command)new XmlBeanRefreshCommand(this.appClassLoader, url));
    }

    public void registerBasePackageFromConfiguration() {
        if (basePackagePrefixes != null) {
            for (String basePackagePrefix : basePackagePrefixes) {
                this.registerBasePackage(basePackagePrefix);
            }
        }
    }

    private void registerBasePackage(final String basePackage) {
        final SpringChangesAnalyzer analyzer = new SpringChangesAnalyzer(this.appClassLoader);
        ClassPathBeanRefreshCommand fooCmd = new ClassPathBeanRefreshCommand();
        this.hotswapTransformer.registerTransformer(this.appClassLoader, this.getClassNameRegExp(basePackage), new HaClassFileTransformer(){

            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                if (classBeingRedefined != null && analyzer.isReloadNeeded(classBeingRedefined, classfileBuffer)) {
                    SpringPlugin.this.scheduler.scheduleCommand((Command)new ClassPathBeanRefreshCommand(classBeingRedefined.getClassLoader(), basePackage, className, classfileBuffer));
                }
                return classfileBuffer;
            }

            public boolean isForRedefinitionOnly() {
                return true;
            }
        });
    }

    public void registerComponentScanBasePackage(final String basePackage) {
        LOGGER.info("Registering basePackage {}", new Object[]{basePackage});
        this.registerBasePackage(basePackage);
        Enumeration<URL> resourceUrls = null;
        try {
            resourceUrls = this.getResources(basePackage);
        }
        catch (IOException e) {
            LOGGER.error("Unable to resolve base package {} in classloader {}.", new Object[]{basePackage, this.appClassLoader});
            return;
        }
        while (resourceUrls.hasMoreElements()) {
            URL basePackageURL = resourceUrls.nextElement();
            if (!IOUtils.isFileURL((URL)basePackageURL)) {
                LOGGER.debug("Spring basePackage '{}' - unable to watch files on URL '{}' for changes (JAR file?), limited hotswap reload support. Use extraClassPath configuration to locate class file on filesystem.", new Object[]{basePackage, basePackageURL});
                continue;
            }
            this.watcher.addEventListener(this.appClassLoader, basePackageURL, new WatchEventListener(){

                public void onEvent(WatchFileEvent event) {
                    if (event.isFile() && event.getURI().toString().endsWith(".class")) {
                        String className;
                        try {
                            className = IOUtils.urlToClassName((URI)event.getURI());
                        }
                        catch (IOException e) {
                            LOGGER.trace("Watch event on resource '{}' skipped, probably Ok because of delete/create event sequence (compilation not finished yet).", (Throwable)e, new Object[]{event.getURI()});
                            return;
                        }
                        if (!ClassLoaderHelper.isClassLoaded((ClassLoader)SpringPlugin.this.appClassLoader, (String)className)) {
                            SpringPlugin.this.scheduler.scheduleCommand((Command)new ClassPathBeanRefreshCommand(SpringPlugin.this.appClassLoader, basePackage, className, event), 600);
                        }
                    }
                }
            });
        }
    }

    private String getClassNameRegExp(String basePackage) {
        String regexp = basePackage;
        while (regexp.contains("**")) {
            regexp = regexp.replace("**", ".*");
        }
        if (!regexp.endsWith(".*")) {
            regexp = regexp + ".*";
        }
        return regexp;
    }

    private Enumeration<URL> getResources(String basePackage) throws IOException {
        String resourceName = basePackage;
        int index = resourceName.indexOf(42);
        if (index != -1 && (index = (resourceName = resourceName.substring(0, index)).lastIndexOf(46)) != -1) {
            resourceName = resourceName.substring(0, index);
        }
        resourceName = resourceName.replace('.', '/');
        return this.appClassLoader.getResources(resourceName);
    }

    @OnClassLoadEvent(classNameRegexp="org.springframework.beans.factory.support.DefaultListableBeanFactory")
    public static void register(CtClass clazz) throws NotFoundException, CannotCompileException {
        StringBuilder src = new StringBuilder("{");
        src.append("setCacheBeanMetadata(false);");
        src.append(PluginManagerInvoker.buildInitializePlugin(SpringPlugin.class));
        src.append(PluginManagerInvoker.buildCallPluginMethod(SpringPlugin.class, (String)"init", (String[])new String[]{"org.springframework.core.SpringVersion.getVersion()", String.class.getName()}));
        src.append("}");
        for (CtConstructor constructor : clazz.getDeclaredConstructors()) {
            constructor.insertBeforeBody(src.toString());
        }
        CtMethod method = clazz.getDeclaredMethod("freezeConfiguration");
        method.insertBefore("org.hotswap.agent.plugin.spring.ResetSpringStaticCaches.resetBeanNamesByType(this); setAllowRawInjectionDespiteWrapping(true); ");
    }

    @OnClassLoadEvent(classNameRegexp="org.springframework.aop.framework.CglibAopProxy")
    public static void cglibAopProxyDisableCache(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod method = ctClass.getDeclaredMethod("createEnhancer");
        method.setBody("{org.springframework.cglib.proxy.Enhancer enhancer = new org.springframework.cglib.proxy.Enhancer();enhancer.setUseCache(false);return enhancer;}");
        LOGGER.debug("org.springframework.aop.framework.CglibAopProxy - cglib Enhancer cache disabled", new Object[0]);
    }
}

