/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.scanner;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.ResetBeanPostProcessorCaches;
import org.hotswap.agent.plugin.spring.ResetRequestMappingCaches;
import org.hotswap.agent.plugin.spring.ResetSpringStaticCaches;
import org.hotswap.agent.plugin.spring.SpringPlugin;
import org.hotswap.agent.plugin.spring.getbean.ProxyReplacer;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class ClassPathBeanDefinitionScannerAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassPathBeanDefinitionScannerAgent.class);
    private static Map<ClassPathBeanDefinitionScanner, ClassPathBeanDefinitionScannerAgent> instances = new HashMap<ClassPathBeanDefinitionScanner, ClassPathBeanDefinitionScannerAgent>();
    public static boolean reloadFlag = false;
    ClassPathBeanDefinitionScanner scanner;
    Set<String> basePackages = new HashSet<String>();
    BeanDefinitionRegistry registry;
    ScopeMetadataResolver scopeMetadataResolver;
    BeanNameGenerator beanNameGenerator;

    public static ClassPathBeanDefinitionScannerAgent getInstance(ClassPathBeanDefinitionScanner scanner) {
        ClassPathBeanDefinitionScannerAgent classPathBeanDefinitionScannerAgent = instances.get(scanner);
        if (classPathBeanDefinitionScannerAgent == null || classPathBeanDefinitionScannerAgent.registry != scanner.getRegistry()) {
            instances.put(scanner, new ClassPathBeanDefinitionScannerAgent(scanner));
        }
        return instances.get(scanner);
    }

    public static ClassPathBeanDefinitionScannerAgent getInstance(String basePackage) {
        for (ClassPathBeanDefinitionScannerAgent scannerAgent : instances.values()) {
            if (!scannerAgent.basePackages.contains(basePackage)) continue;
            return scannerAgent;
        }
        return null;
    }

    private ClassPathBeanDefinitionScannerAgent(ClassPathBeanDefinitionScanner scanner) {
        this.scanner = scanner;
        this.registry = scanner.getRegistry();
        this.scopeMetadataResolver = (ScopeMetadataResolver)ReflectionHelper.get((Object)scanner, (String)"scopeMetadataResolver");
        this.beanNameGenerator = (BeanNameGenerator)ReflectionHelper.get((Object)scanner, (String)"beanNameGenerator");
    }

    public void registerBasePackage(String basePackage) {
        this.basePackages.add(basePackage);
        PluginManagerInvoker.callPluginMethod(SpringPlugin.class, (ClassLoader)this.getClass().getClassLoader(), (String)"registerComponentScanBasePackage", (Class[])new Class[]{String.class}, (Object[])new Object[]{basePackage});
    }

    public static void refreshClass(String basePackage, byte[] classDefinition) throws IOException {
        ResetSpringStaticCaches.reset();
        ClassPathBeanDefinitionScannerAgent scannerAgent = ClassPathBeanDefinitionScannerAgent.getInstance(basePackage);
        if (scannerAgent == null) {
            LOGGER.error("basePackage '{}' not associated with any scannerAgent", new Object[]{basePackage});
            return;
        }
        BeanDefinition beanDefinition = scannerAgent.resolveBeanDefinition(classDefinition);
        if (beanDefinition != null) {
            scannerAgent.defineBean(beanDefinition);
        }
        reloadFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineBean(BeanDefinition candidate) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata(candidate);
            candidate.setScope(scopeMetadata.getScopeName());
            String beanName = this.beanNameGenerator.generateBeanName(candidate, this.registry);
            if (candidate instanceof AbstractBeanDefinition) {
                this.postProcessBeanDefinition((AbstractBeanDefinition)candidate, beanName);
            }
            if (candidate instanceof AnnotatedBeanDefinition) {
                this.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)candidate);
            }
            this.removeIfExists(beanName);
            if (this.checkCandidate(beanName, candidate)) {
                BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(candidate, beanName);
                definitionHolder = this.applyScopedProxyMode(scopeMetadata, definitionHolder, this.registry);
                LOGGER.reload("Registering Spring bean '{}'", new Object[]{beanName});
                LOGGER.debug("Bean definition '{}'", new Object[]{beanName, candidate});
                this.registerBeanDefinition(definitionHolder, this.registry);
                DefaultListableBeanFactory bf = this.maybeRegistryToBeanFactory();
                if (bf != null) {
                    ResetRequestMappingCaches.reset(bf);
                }
                ProxyReplacer.clearAllProxies();
                this.freezeConfiguration();
            }
        }
    }

    private void removeIfExists(String beanName) {
        if (this.registry.containsBeanDefinition(beanName)) {
            LOGGER.debug("Removing bean definition '{}'", new Object[]{beanName});
            DefaultListableBeanFactory bf = this.maybeRegistryToBeanFactory();
            if (bf != null) {
                ResetRequestMappingCaches.reset(bf);
            }
            this.registry.removeBeanDefinition(beanName);
            ResetSpringStaticCaches.reset();
            if (bf != null) {
                ResetBeanPostProcessorCaches.reset(bf);
            }
        }
    }

    private DefaultListableBeanFactory maybeRegistryToBeanFactory() {
        if (this.registry instanceof DefaultListableBeanFactory) {
            return (DefaultListableBeanFactory)this.registry;
        }
        if (this.registry instanceof GenericApplicationContext) {
            return ((GenericApplicationContext)this.registry).getDefaultListableBeanFactory();
        }
        return null;
    }

    private void freezeConfiguration() {
        if (this.registry instanceof DefaultListableBeanFactory) {
            ((DefaultListableBeanFactory)this.registry).freezeConfiguration();
        } else if (this.registry instanceof GenericApplicationContext) {
            ((GenericApplicationContext)this.registry).getDefaultListableBeanFactory().freezeConfiguration();
        }
    }

    public BeanDefinition resolveBeanDefinition(byte[] bytes) throws IOException {
        ByteArrayResource resource = new ByteArrayResource(bytes);
        this.resetCachingMetadataReaderFactoryCache();
        MetadataReader metadataReader = this.getMetadataReaderFactory().getMetadataReader((Resource)resource);
        if (this.isCandidateComponent(metadataReader)) {
            ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
            sbd.setResource((Resource)resource);
            sbd.setSource((Object)resource);
            if (this.isCandidateComponent((AnnotatedBeanDefinition)sbd)) {
                LOGGER.debug("Identified candidate component class '{}'", new Object[]{metadataReader.getClassMetadata().getClassName()});
                return sbd;
            }
            LOGGER.debug("Ignored because not a concrete top-level class '{}'", new Object[]{metadataReader.getClassMetadata().getClassName()});
            return null;
        }
        LOGGER.trace("Ignored because not matching any filter '{}' ", new Object[]{metadataReader.getClassMetadata().getClassName()});
        return null;
    }

    private MetadataReaderFactory getMetadataReaderFactory() {
        return (MetadataReaderFactory)ReflectionHelper.get((Object)this.scanner, (String)"metadataReaderFactory");
    }

    private void resetCachingMetadataReaderFactoryCache() {
        if (this.getMetadataReaderFactory() instanceof CachingMetadataReaderFactory) {
            Map metadataReaderCache = (Map)ReflectionHelper.getNoException((Object)this.getMetadataReaderFactory(), CachingMetadataReaderFactory.class, (String)"metadataReaderCache");
            if (metadataReaderCache == null) {
                metadataReaderCache = (Map)ReflectionHelper.getNoException((Object)this.getMetadataReaderFactory(), CachingMetadataReaderFactory.class, (String)"classReaderCache");
            }
            if (metadataReaderCache != null) {
                metadataReaderCache.clear();
                LOGGER.debug("Cache cleared: CachingMetadataReaderFactory.clearCache()", new Object[0]);
            } else {
                LOGGER.warning("Cache NOT cleared: neither CachingMetadataReaderFactory.metadataReaderCache nor clearCache does not exist.", new Object[0]);
            }
        }
    }

    private BeanDefinitionHolder applyScopedProxyMode(ScopeMetadata metadata, BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        return (BeanDefinitionHolder)ReflectionHelper.invoke(null, AnnotationConfigUtils.class, (String)"applyScopedProxyMode", (Class[])new Class[]{ScopeMetadata.class, BeanDefinitionHolder.class, BeanDefinitionRegistry.class}, (Object[])new Object[]{metadata, definition, registry});
    }

    private void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        ReflectionHelper.invoke((Object)this.scanner, ClassPathBeanDefinitionScanner.class, (String)"registerBeanDefinition", (Class[])new Class[]{BeanDefinitionHolder.class, BeanDefinitionRegistry.class}, (Object[])new Object[]{definitionHolder, registry});
    }

    private boolean checkCandidate(String beanName, BeanDefinition candidate) {
        return (Boolean)ReflectionHelper.invoke((Object)this.scanner, ClassPathBeanDefinitionScanner.class, (String)"checkCandidate", (Class[])new Class[]{String.class, BeanDefinition.class}, (Object[])new Object[]{beanName, candidate});
    }

    private void processCommonDefinitionAnnotations(AnnotatedBeanDefinition candidate) {
        ReflectionHelper.invoke(null, AnnotationConfigUtils.class, (String)"processCommonDefinitionAnnotations", (Class[])new Class[]{AnnotatedBeanDefinition.class}, (Object[])new Object[]{candidate});
    }

    private void postProcessBeanDefinition(AbstractBeanDefinition candidate, String beanName) {
        ReflectionHelper.invoke((Object)this.scanner, ClassPathBeanDefinitionScanner.class, (String)"postProcessBeanDefinition", (Class[])new Class[]{AbstractBeanDefinition.class, String.class}, (Object[])new Object[]{candidate, beanName});
    }

    private boolean isCandidateComponent(AnnotatedBeanDefinition sbd) {
        return (Boolean)ReflectionHelper.invoke((Object)this.scanner, ClassPathScanningCandidateComponentProvider.class, (String)"isCandidateComponent", (Class[])new Class[]{AnnotatedBeanDefinition.class}, (Object[])new Object[]{sbd});
    }

    private boolean isCandidateComponent(MetadataReader metadataReader) {
        return (Boolean)ReflectionHelper.invoke((Object)this.scanner, ClassPathScanningCandidateComponentProvider.class, (String)"isCandidateComponent", (Class[])new Class[]{MetadataReader.class}, (Object[])new Object[]{metadataReader});
    }
}

