/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.scanner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.watch.WatchFileEvent;

public class ClassPathBeanRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassPathBeanRefreshCommand.class);
    ClassLoader appClassLoader;
    String basePackage;
    String className;
    WatchFileEvent event;
    byte[] classDefinition;

    public ClassPathBeanRefreshCommand() {
    }

    public ClassPathBeanRefreshCommand(ClassLoader appClassLoader, String basePackage, String className, byte[] classDefinition) {
        this.appClassLoader = appClassLoader;
        this.basePackage = basePackage;
        this.className = className;
        this.classDefinition = classDefinition;
    }

    public ClassPathBeanRefreshCommand(ClassLoader appClassLoader, String basePackage, String className, WatchFileEvent event) {
        this.appClassLoader = appClassLoader;
        this.basePackage = basePackage;
        this.event = event;
        this.className = className;
    }

    public void executeCommand() {
        if (this.isDeleteEvent()) {
            LOGGER.trace("Skip Spring reload for delete event on class '{}'", new Object[]{this.className});
            return;
        }
        try {
            if (this.classDefinition == null) {
                try {
                    this.classDefinition = IOUtils.toByteArray((URI)this.event.getURI());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("File {} not found on filesystem (deleted?). Unable to refresh associated Spring bean.", new Object[]{this.event.getURI()});
                    return;
                }
            }
            LOGGER.debug("Executing ClassPathBeanDefinitionScannerAgent.refreshClass('{}')", new Object[]{this.className});
            Class<?> clazz = Class.forName("org.hotswap.agent.plugin.spring.scanner.ClassPathBeanDefinitionScannerAgent", true, this.appClassLoader);
            Method method = clazz.getDeclaredMethod("refreshClass", String.class, byte[].class);
            method.invoke(null, this.basePackage, this.classDefinition);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error refreshing class {} in classLoader {}", (Throwable)e, new Object[]{this.className, this.appClassLoader});
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, Spring class not found in application classloader", e);
        }
    }

    private boolean isDeleteEvent() {
        ArrayList<ClassPathBeanRefreshCommand> mergedCommands = new ArrayList<ClassPathBeanRefreshCommand>();
        for (Command command : this.getMergedCommands()) {
            mergedCommands.add((ClassPathBeanRefreshCommand)command);
        }
        mergedCommands.add(this);
        boolean createFound = false;
        boolean deleteFound = false;
        for (ClassPathBeanRefreshCommand command : mergedCommands) {
            if (command.event == null) continue;
            if (command.event.getEventType().equals((Object)FileEvent.DELETE)) {
                deleteFound = true;
            }
            if (!command.event.getEventType().equals((Object)FileEvent.CREATE)) continue;
            createFound = true;
        }
        LOGGER.trace("isDeleteEvent result {}: createFound={}, deleteFound={}", new Object[]{createFound, deleteFound});
        return !createFound && deleteFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ClassPathBeanRefreshCommand that = (ClassPathBeanRefreshCommand)((Object)o);
        if (!this.appClassLoader.equals(that.appClassLoader)) {
            return false;
        }
        return this.className.equals(that.className);
    }

    public int hashCode() {
        int result = this.appClassLoader.hashCode();
        result = 31 * result + this.className.hashCode();
        return result;
    }

    public String toString() {
        return "ClassPathBeanRefreshCommand{appClassLoader=" + this.appClassLoader + ", basePackage='" + this.basePackage + '\'' + ", className='" + this.className + '\'' + '}';
    }
}

