/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.scanner;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.ResetBeanPostProcessorCaches;
import org.hotswap.agent.plugin.spring.SpringPlugin;
import org.hotswap.agent.plugin.spring.getbean.ProxyReplacer;
import org.hotswap.agent.plugin.spring.scanner.ClassPathBeanDefinitionScannerAgent;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class XmlBeanDefinitionScannerAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(XmlBeanDefinitionScannerAgent.class);
    private static Map<String, XmlBeanDefinitionScannerAgent> instances = new HashMap<String, XmlBeanDefinitionScannerAgent>();
    BeanDefinitionReader reader;
    public static boolean reloadFlag = false;
    private static boolean basePackageInited = false;

    public static void registerXmlBeanDefinitionScannerAgent(XmlBeanDefinitionReader reader, Resource resource) {
        String path;
        if (resource instanceof ClassPathResource) {
            path = ((ClassPathResource)resource).getPath();
        } else {
            try {
                path = XmlBeanDefinitionScannerAgent.convertToClasspathURL(resource.getURL().getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("Cannot get url from resource: {}", new Object[]{resource});
                return;
            }
        }
        instances.put(path, new XmlBeanDefinitionScannerAgent((BeanDefinitionReader)reader));
    }

    public static void reloadXml(URL url) {
        XmlBeanDefinitionScannerAgent xmlBeanDefinitionScannerAgent = instances.get(XmlBeanDefinitionScannerAgent.convertToClasspathURL(url.getPath()));
        if (xmlBeanDefinitionScannerAgent == null) {
            LOGGER.warning("url " + url + " is not associated with any XmlBeanDefinitionScannerAgent, not reloading", new Object[0]);
            return;
        }
        try {
            xmlBeanDefinitionScannerAgent.reloadBeanFromXml(url);
        }
        catch (BeanDefinitionParsingException e) {
            LOGGER.error("Reloading XML failed: {}", new Object[]{e.getMessage()});
        }
    }

    private XmlBeanDefinitionScannerAgent(BeanDefinitionReader reader) {
        this.reader = reader;
        if (SpringPlugin.basePackagePrefixes != null && !basePackageInited) {
            ClassPathBeanDefinitionScannerAgent xmlBeanDefinitionScannerAgent = ClassPathBeanDefinitionScannerAgent.getInstance(new ClassPathBeanDefinitionScanner(reader.getRegistry()));
            for (String basePackage : SpringPlugin.basePackagePrefixes) {
                xmlBeanDefinitionScannerAgent.registerBasePackage(basePackage);
            }
            basePackageInited = true;
        }
    }

    private static String convertToClasspathURL(String filePath) {
        String[] paths = filePath.split("src/main/resources/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("WEB-INF/classes/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("WEB-INF/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("target/classes/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("target/test-classes/");
        if (paths.length == 2) {
            return paths[1];
        }
        LOGGER.error("failed to convert filePath {} to classPath path", new Object[]{filePath});
        return filePath;
    }

    public void reloadBeanFromXml(URL url) {
        LOGGER.info("Reloading XML file: " + url, new Object[0]);
        this.reader.loadBeanDefinitions((Resource)new FileSystemResource(url.getPath()));
        ResetBeanPostProcessorCaches.reset(this.maybeRegistryToBeanFactory());
        ProxyReplacer.clearAllProxies();
        reloadFlag = false;
    }

    private DefaultListableBeanFactory maybeRegistryToBeanFactory() {
        BeanDefinitionRegistry registry = this.reader.getRegistry();
        if (registry instanceof DefaultListableBeanFactory) {
            return (DefaultListableBeanFactory)registry;
        }
        if (registry instanceof GenericApplicationContext) {
            return ((GenericApplicationContext)registry).getDefaultListableBeanFactory();
        }
        return null;
    }
}

