/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.scanner;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;

public class XmlBeanRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(XmlBeanRefreshCommand.class);
    URL url;
    ClassLoader appClassLoader;

    public XmlBeanRefreshCommand(ClassLoader appClassLoader, URL url) {
        this.appClassLoader = appClassLoader;
        this.url = url;
    }

    public void executeCommand() {
        if (!new File(this.url.getPath()).exists()) {
            LOGGER.trace("Skip Spring reload for delete event on file '{}'", new Object[]{this.url});
            return;
        }
        LOGGER.info("Executing XmlBeanDefinitionScannerAgent.reloadXml('{}')", new Object[]{this.url});
        try {
            Class<?> clazz = Class.forName("org.hotswap.agent.plugin.spring.scanner.XmlBeanDefinitionScannerAgent", true, this.appClassLoader);
            Method method = clazz.getDeclaredMethod("reloadXml", URL.class);
            method.invoke(null, this.url);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, maybe failed to hook spring method to init plugin with right classLoader", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, Spring class not found in application classloader", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error refreshing xml {} in classLoader {}", (Throwable)e, new Object[]{this.url, this.appClassLoader});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        XmlBeanRefreshCommand that = (XmlBeanRefreshCommand)((Object)o);
        return this.url.equals(that.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "XmlBeanRefreshCommand{url='" + this.url + '\'' + '}';
    }
}

