/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.Stub;
import org.apache.axis2.transport.http.impl.httpclient4.HttpTransportPropertiesImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.platform.Version;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.utils.Utils;
import org.hpccsystems.ws.client.wrappers.ArrayOfECLExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.EspSoapFaultWrapper;
import org.w3c.dom.Document;

public abstract class BaseHPCCWsClient
extends DataSingleton {
    protected static final Logger log = LogManager.getLogger(BaseHPCCWsClient.class);
    public static final String DEAFULTECLWATCHPORT = "8010";
    public static final String DEFAULTECLWATCHTLSPORT = "18010";
    public static String DEFAULTSERVICEPORT = "8010";
    protected Connection wsconn = null;
    protected boolean verbose = false;
    protected String initErrMessage = "";
    protected Version targetHPCCBuildVersion = null;
    protected Double targetESPInterfaceVer = null;
    protected Stub stub;

    public abstract Stub getDefaultStub() throws AxisFault;

    public static String getServiceVersion(BaseHPCCWsClient client) {
        String ver = null;
        if (client != null) {
            try {
                Stub stub = client.getDefaultStub();
                ver = BaseHPCCWsClient.getServiceVersion(stub);
            }
            catch (AxisFault e) {
                e.printStackTrace();
            }
        }
        return ver;
    }

    public static String getServiceVersion(Stub stub) {
        String address;
        String ver = null;
        if (stub != null && (address = BaseHPCCWsClient.getServiceWSDLURL(stub)) != null && !address.isEmpty()) {
            ver = Utils.parseVersionFromWSDLURL(address);
        }
        return ver;
    }

    public static String getServiceWSDLURL(Stub stub) {
        Options options;
        String address = null;
        if (stub != null && (options = stub._getServiceClient().getOptions()) != null) {
            address = options.getTo().getAddress();
        }
        return address;
    }

    public static int getServiceWSDLPort(Stub stub) throws MalformedURLException {
        String address;
        int port = -1;
        if (stub != null && (address = BaseHPCCWsClient.getServiceWSDLURL(stub)) != null && !address.isEmpty()) {
            port = new URL(address).getPort();
        }
        return port;
    }

    public URL getConnectionURL() throws Exception {
        URL address = null;
        this.verifyStub();
        Options opt = this.stub._getServiceClient().getOptions();
        EndpointReference toAddress = opt.getTo();
        if (toAddress != null) {
            address = new URL(toAddress.getAddress());
        }
        return address;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean hasInitError() {
        return !this.initErrMessage.isEmpty();
    }

    public String getInitError() {
        return this.initErrMessage;
    }

    protected Stub verifyStub() throws Exception {
        if (this.stub != null) {
            return this.stub;
        }
        throw new Exception("WS Client Stub not available." + (this.hasInitError() ? "\n" + this.initErrMessage : ""));
    }

    @Override
    public boolean equals(Object aThat) {
        HttpTransportPropertiesImpl.Authenticator thatauth;
        Options thatopt;
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof BaseHPCCWsClient)) {
            return false;
        }
        if (!aThat.getClass().isInstance(this)) {
            return false;
        }
        BaseHPCCWsClient that = (BaseHPCCWsClient)aThat;
        try {
            Stub thatStub = that.verifyStub();
            thatopt = thatStub._getServiceClient().getOptions();
        }
        catch (Exception e) {
            thatopt = null;
        }
        if (thatopt == null) {
            return false;
        }
        Options thisoptions = this.stub._getServiceClient().getOptions();
        HttpTransportPropertiesImpl.Authenticator thisauth = (HttpTransportPropertiesImpl.Authenticator)thisoptions.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_");
        if (!EqualsUtil.areSameNullState(thisauth, thatauth = (HttpTransportPropertiesImpl.Authenticator)thatopt.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_"))) {
            return false;
        }
        return EqualsUtil.areEqual(thisoptions.getTo().toString(), thatopt.getTo().toString()) && EqualsUtil.areEqual(thisoptions.getProperty("SO_TIMEOUT"), thatopt.getProperty("SO_TIMEOUT")) && EqualsUtil.areEqual(thisoptions.getProperty("CONNECTION_TIMEOUT"), thatopt.getProperty("CONNECTION_TIMEOUT")) && EqualsUtil.areEqual(thisoptions.getProperty("__CHUNKED__"), thatopt.getProperty("__CHUNKED__")) && (thisauth == null || EqualsUtil.areEqual(thisauth.getUsername(), thatauth.getUsername()) && EqualsUtil.areEqual(thisauth.getPassword(), thatauth.getPassword()));
    }

    @Override
    public int hashCode() {
        int result = 23;
        if (this.hasInitError()) {
            result = HashCodeUtil.hash(result, this.getInitError());
            return result;
        }
        Options ops = this.stub._getServiceClient().getOptions();
        result = HashCodeUtil.hash(result, ops.getTo());
        HttpTransportPropertiesImpl.Authenticator thisauth = (HttpTransportPropertiesImpl.Authenticator)ops.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_");
        result = HashCodeUtil.hash(result, thisauth == null ? "" : thisauth.getUsername());
        result = HashCodeUtil.hash(result, thisauth == null ? "" : thisauth.getPassword());
        result = HashCodeUtil.hash(result, ops.getProperty("SO_TIMEOUT"));
        result = HashCodeUtil.hash(result, ops.getProperty("CONNECTION_TIMEOUT"));
        return result;
    }

    @Override
    protected boolean isComplete() {
        return false;
    }

    @Override
    protected void fastRefresh() {
    }

    @Override
    protected void fullRefresh() {
    }

    protected void setStubConnectionTO(int millis) throws AxisFault {
        Options opt = this.stub._getServiceClient().getOptions();
        opt.setProperty("CONNECTION_TIMEOUT", (Object)millis);
        this.stub._getServiceClient().setOptions(opt);
    }

    protected Integer getStubConnectionTO() throws AxisFault {
        Integer to = null;
        if (this.stub != null) {
            Options opt = this.stub._getServiceClient().getOptions();
            try {
                to = (Integer)opt.getProperty("CONNECTION_TIMEOUT");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return to;
    }

    public static Stub setStubOptions(Stub thestub, Connection connection) throws AxisFault {
        Options opt = thestub._getServiceClient().getOptions();
        opt.setProperty("SO_TIMEOUT", (Object)connection.getSocketTimeoutMilli());
        opt.setProperty("CONNECTION_TIMEOUT", (Object)connection.getConnectTimeoutMilli());
        opt = BaseHPCCWsClient.setClientAuth(connection.getUserName(), connection.getPassword(), opt);
        opt.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        thestub._getServiceClient().setOptions(opt);
        return thestub;
    }

    public static Options setClientAuth(String user, String pass, Options opt) {
        if (user != null && pass != null && opt != null) {
            HttpTransportPropertiesImpl.Authenticator basicAuth = new HttpTransportPropertiesImpl.Authenticator();
            basicAuth.setUsername(user);
            basicAuth.setPassword(pass);
            basicAuth.setPreemptiveAuthentication(true);
            opt.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)basicAuth);
            opt.setProperty("Basic", (Object)basicAuth);
        }
        return opt;
    }

    protected void handleEspSoapFaults(EspSoapFaultWrapper e) throws EspSoapFaultWrapper {
        if (e != null) {
            this.handleEspSoapFaults(e, null);
        }
    }

    protected void handleEspSoapFaults(EspSoapFaultWrapper e, String message) throws EspSoapFaultWrapper {
        if (e != null) {
            if (message != null && !message.isEmpty()) {
                e.setWsClientMessage(message);
            }
            log.error(e.toString());
            throw e;
        }
    }

    protected void handleEspExceptions(ArrayOfEspExceptionWrapper exp, String message) throws ArrayOfEspExceptionWrapper {
        if (exp == null || exp.getExceptions() == null || exp.getExceptions().size() <= 0) {
            return;
        }
        if (message != null && !message.isEmpty()) {
            exp.setWsClientMessage(message);
        }
        log.error(exp.toString());
        throw exp;
    }

    protected void handleEspExceptions(ArrayOfEspExceptionWrapper exp) throws ArrayOfEspExceptionWrapper {
        this.handleEspExceptions(exp, null);
    }

    protected void handleECLExceptions(ArrayOfECLExceptionWrapper eclexceptions) throws Exception, ArrayOfECLExceptionWrapper {
        this.handleECLExceptions(eclexceptions, null);
    }

    protected void handleECLExceptions(ArrayOfECLExceptionWrapper eclExceptions, String message) throws Exception, ArrayOfECLExceptionWrapper {
        if (eclExceptions == null || eclExceptions.getECLException() == null || eclExceptions.getECLException().size() <= 0) {
            return;
        }
        if (message != null && !message.isEmpty()) {
            eclExceptions.setWsClientMessage(message);
        }
        log.error(eclExceptions.toString());
        throw eclExceptions;
    }

    public double getTargetESPInterfaceVersion() {
        if (this.targetESPInterfaceVer == null) {
            this.loadESPRuntimeInterfaceVer();
        }
        return this.targetESPInterfaceVer;
    }

    protected void setActiveConnectionInfo(Connection conn) {
        this.wsconn = conn;
    }

    public abstract String getServiceURI();

    protected void loadESPRuntimeInterfaceVer() {
        if (this.wsconn != null) {
            if (this.getServiceURI() == null || this.getServiceURI().isEmpty()) {
                log.warn("Could not load ESP interface version, ensure target ws name is provided");
            } else {
                String response = null;
                try {
                    response = this.wsconn.sendGetRequest(this.getServiceURI() + "/version_");
                }
                catch (Exception httpGetException) {
                    log.error("Encountered error fetching ESP interface version for " + this.wsconn.getBaseUrl() + this.getServiceURI() + "\n" + httpGetException.getLocalizedMessage());
                }
                if (response == null || response.isEmpty()) {
                    log.error("Received empty ESP interface version response (" + this.wsconn.getBaseUrl() + this.getServiceURI() + ")");
                } else {
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder parser = factory.newDocumentBuilder();
                        Document document = parser.parse(new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8)));
                        XPath xpath = XPathFactory.newInstance().newXPath();
                        XPathExpression expr = xpath.compile("string(/VersionInfo/Version)");
                        this.targetESPInterfaceVer = (double)((Double)expr.evaluate(document, XPathConstants.NUMBER));
                        log.info(this.wsconn.getBaseUrl() + this.getServiceURI() + " version: " + this.targetESPInterfaceVer);
                    }
                    catch (Exception e) {
                        log.error("Encountered error parsing ESP interface version for " + this.wsconn.getBaseUrl() + this.getServiceURI() + "\n" + e.getLocalizedMessage());
                    }
                }
            }
        } else {
            log.warn("Could not load ESP interface version, ensure client is properly initialized");
        }
    }

    protected boolean compatibilityCheck(int major, int minor, int point) {
        if (this.targetHPCCBuildVersion == null) {
            return false;
        }
        return this.targetHPCCBuildVersion.isEqualOrNewerThan(major, minor, point);
    }

    protected boolean compatibilityCheck(Version input) {
        if (this.targetHPCCBuildVersion == null || input == null) {
            return false;
        }
        return this.targetHPCCBuildVersion.isEqualOrNewerThan(input);
    }
}

