/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.HPCCFileSprayClient;
import org.hpccsystems.ws.client.HPCCWsCodeSignClient;
import org.hpccsystems.ws.client.HPCCWsDFUClient;
import org.hpccsystems.ws.client.HPCCWsDFUXRefClient;
import org.hpccsystems.ws.client.HPCCWsFileIOClient;
import org.hpccsystems.ws.client.HPCCWsPackageProcessClient;
import org.hpccsystems.ws.client.HPCCWsResourcesClient;
import org.hpccsystems.ws.client.HPCCWsSMCClient;
import org.hpccsystems.ws.client.HPCCWsSQLClient;
import org.hpccsystems.ws.client.HPCCWsTopologyClient;
import org.hpccsystems.ws.client.HPCCWsWorkUnitsClient;
import org.hpccsystems.ws.client.extended.HPCCWsAttributesClient;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.DataSingletonCollection;
import org.hpccsystems.ws.client.utils.DelimitedDataOptions;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.utils.Utils;
import org.hpccsystems.ws.client.wrappers.ArrayOfECLExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.ProgressResponseWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WorkunitWrapper;

public class HPCCWsClient
extends DataSingleton {
    private static final Logger log = LogManager.getLogger(HPCCWsClient.class);
    public static DataSingletonCollection All = new DataSingletonCollection();
    public static DataSingletonCollection SubClients = new DataSingletonCollection();
    public static final String defaultTargetWsECLWatchHost = "localhost";
    public static final String defaultTWsECLWatchPort = "8010";
    public static final String defaultTWsECLWatchSSLPort = "18010";
    protected boolean verbosemode = false;
    protected Connection connection = null;
    protected Object connectionLock = new Object();

    public static HPCCWsClient get(String protocol, String targetWsECLWatchAddress, int targetWsECLWatchPort, String user, String password) {
        return (HPCCWsClient)All.get(new HPCCWsClient(protocol, targetWsECLWatchAddress, Integer.toString(targetWsECLWatchPort), user, password));
    }

    public static HPCCWsClient getNoCreate(String protocol, String targetWsECLWatchAddress, int targetWsECLWatchPort, String user, String password) {
        return (HPCCWsClient)All.getNoCreate(new HPCCWsClient(protocol, targetWsECLWatchAddress, Integer.toString(targetWsECLWatchPort), user, password));
    }

    public static void remove(HPCCWsClient p) {
        All.remove(p);
    }

    public boolean isVerbosemode() {
        return this.verbosemode;
    }

    public void setVerbosemode(boolean verbosemode) {
        this.verbosemode = verbosemode;
    }

    protected HPCCWsClient() {
        this(defaultTargetWsECLWatchHost, defaultTWsECLWatchPort);
    }

    protected HPCCWsClient(String protocol) {
        this(protocol, defaultTargetWsECLWatchHost, protocol.equalsIgnoreCase("https") ? defaultTWsECLWatchSSLPort : defaultTWsECLWatchPort);
    }

    protected HPCCWsClient(String targetWsECLWatchAddress, String targetWsECLWatchPort) {
        this("http", targetWsECLWatchAddress, targetWsECLWatchPort);
    }

    protected HPCCWsClient(String protocol, String targetWsECLWatchAddress, String targetWsECLWatchPort) {
        this.connection = new Connection(protocol, targetWsECLWatchAddress, targetWsECLWatchPort);
    }

    public HPCCWsClient(String targetWsECLWatchAddress, String targetWsECLWatchPort, String username, String password) {
        this("http", targetWsECLWatchAddress, targetWsECLWatchPort, username, password);
    }

    protected HPCCWsClient(String protocol, String targetWsECLWatchAddress, String targetWsECLWatchPort, String username, String password) {
        this.connection = new Connection(protocol, targetWsECLWatchAddress, targetWsECLWatchPort);
        this.connection.setCredentials(username, password);
    }

    protected HPCCWsClient(Connection conn) {
        this.updateConnection(conn);
    }

    public synchronized void update(String protocol, String targetWsECLWatchAddress, String targetWsECLWatchPort, String username, String password) {
        Connection newConnection = new Connection(protocol, targetWsECLWatchAddress, targetWsECLWatchPort);
        newConnection.setCredentials(username, password);
        this.updateConnection(newConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateConnection(Connection conn) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.connection = conn;
            SubClients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.connection;
        }
    }

    public synchronized boolean pingServer() throws Exception {
        HPCCWsWorkUnitsClient wsWorkunitsClient = this.getWsWorkunitsClient();
        try {
            return wsWorkunitsClient.testWUQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isContainerized() throws Exception {
        HPCCWsSMCClient wsSMCClient = this.getWsSMCClient();
        try {
            return wsSMCClient.isContainerized();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsResourcesClient getHPCCWsResourcesClient(String wsresourcesport) {
        Object object = this.connectionLock;
        synchronized (object) {
            Connection tempConn = new Connection(this.connection.getProtocol(), this.connection.getHost(), wsresourcesport);
            tempConn.setCredentials(this.connection.getUserName(), this.connection.getPassword());
            return (HPCCWsResourcesClient)SubClients.get(HPCCWsResourcesClient.get(tempConn));
        }
    }

    public HPCCWsResourcesClient getHPCCWsResourcesClient() {
        return this.getHPCCWsResourcesClient(String.valueOf(HPCCWsResourcesClient.getServiceWSDLPort()));
    }

    public String getHPCCWsResourcesClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsResourcesClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsCodeSignClient getWsCodeSignClient(String codeSignPort) {
        Object object = this.connectionLock;
        synchronized (object) {
            Connection tempConn = new Connection(this.connection.getProtocol(), this.connection.getHost(), codeSignPort);
            tempConn.setCredentials(this.connection.getUserName(), this.connection.getPassword());
            return (HPCCWsCodeSignClient)SubClients.get(HPCCWsCodeSignClient.get(tempConn));
        }
    }

    public HPCCWsCodeSignClient getWsCodeSignClient() {
        return this.getWsCodeSignClient(String.valueOf(HPCCWsCodeSignClient.getServiceWSDLPort()));
    }

    public String getHPCCWsCodeSignClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsCodeSignClient.getServiceWSDLURL());
    }

    public String getWsSQLClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsSQLClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsSQLClient getWsSQLClient(String wsSQLPort) {
        Object object = this.connectionLock;
        synchronized (object) {
            Connection tempConn = new Connection(this.connection.getProtocol(), this.connection.getHost(), wsSQLPort);
            tempConn.setCredentials(this.connection.getUserName(), this.connection.getPassword());
            return (HPCCWsSQLClient)SubClients.get(HPCCWsSQLClient.get(tempConn));
        }
    }

    public HPCCWsSQLClient getWsSQLClient() {
        return this.getWsSQLClient(String.valueOf(HPCCWsSQLClient.getServiceWSDLPort()));
    }

    public String getWsAttributesClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsAttributesClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsAttributesClient getWsAttributesClient(String wsAttributesPort) {
        Object object = this.connectionLock;
        synchronized (object) {
            Connection tempConn = new Connection(this.connection.getProtocol(), this.connection.getHost(), wsAttributesPort);
            tempConn.setCredentials(this.connection.getUserName(), this.connection.getPassword());
            return (HPCCWsAttributesClient)SubClients.get(HPCCWsAttributesClient.get(tempConn));
        }
    }

    public HPCCWsAttributesClient getWsAttributesClient() {
        return this.getWsAttributesClient(String.valueOf(HPCCWsAttributesClient.getServiceWSDLPort()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCFileSprayClient getFileSprayClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCFileSprayClient)SubClients.get(HPCCFileSprayClient.get(this.connection));
        }
    }

    public String getHPCCWsPackageProcessClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsPackageProcessClient.getServiceWSDLURL());
    }

    public String getWsFileIOClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsFileIOClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsFileIOClient getWsFileIOClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCWsFileIOClient)SubClients.get(HPCCWsFileIOClient.get(this.connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsPackageProcessClient getWsPackageProcessClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCWsPackageProcessClient)SubClients.get(HPCCWsPackageProcessClient.get(this.connection));
        }
    }

    public String getWsTopologyClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsTopologyClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsTopologyClient getWsTopologyClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCWsTopologyClient)SubClients.get(HPCCWsTopologyClient.get(this.connection));
        }
    }

    public String getwsDFUClientClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsDFUClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsDFUClient getWsDFUClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCWsDFUClient)SubClients.get(HPCCWsDFUClient.get(this.connection));
        }
    }

    public String getwsDFUXRefClientClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsDFUXRefClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsDFUXRefClient getWsDFUXRefClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCWsDFUXRefClient)SubClients.get(HPCCWsDFUXRefClient.get(this.connection));
        }
    }

    public String getWsSMCClientClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsSMCClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsSMCClient getWsSMCClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCWsSMCClient)SubClients.get(HPCCWsSMCClient.get(this.connection));
        }
    }

    public String getWsWorkunitsClientVer() {
        return Utils.parseVersionFromWSDLURL(HPCCWsWorkUnitsClient.getServiceWSDLURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPCCWsWorkUnitsClient getWsWorkunitsClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return (HPCCWsWorkUnitsClient)SubClients.get(HPCCWsWorkUnitsClient.get(this.connection));
        }
    }

    public String[] getAvailableClusterGroups() throws Exception {
        HPCCWsTopologyClient hpccWsTopologyClient = HPCCWsTopologyClient.get(this.connection);
        try {
            if (hpccWsTopologyClient != null) {
                return hpccWsTopologyClient.getValidTargetGroupNames();
            }
            throw new Exception("Could not initialize HPCC WsTopology Client");
        }
        catch (ArrayOfEspExceptionWrapper e) {
            log.error(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String[] getAvailableClusterNames(String clusterGroupType) throws Exception, ArrayOfEspExceptionWrapper {
        HPCCWsTopologyClient wsTopologyClient = HPCCWsTopologyClient.get(this.connection);
        if (wsTopologyClient != null) {
            return wsTopologyClient.getValidClusterNames(clusterGroupType);
        }
        throw new Exception("Could not initialize HPCC WsTopology Client");
    }

    public List<String> getAvailableTargetClusterNames() throws Exception, ArrayOfEspExceptionWrapper {
        HPCCWsTopologyClient wsTopologyClient = HPCCWsTopologyClient.get(this.connection);
        if (wsTopologyClient != null) {
            return wsTopologyClient.getValidTargetClusterNames();
        }
        throw new Exception("Could not initialize HPCC WsTopology Client");
    }

    public boolean sprayFlatHPCCFile(String fileName, String targetFileLabel, int recordSize, String targetCluster, boolean overwritesprayedfile) {
        boolean success = true;
        try {
            HPCCFileSprayClient fileSprayClient = this.getFileSprayClient();
            if (fileSprayClient == null) {
                throw new Exception("Could not initialize HPCC fileSpray Client");
            }
            success = this.handleSprayResponse(fileSprayClient.sprayFixedLocalDropZone(fileName, recordSize, targetFileLabel, "", targetCluster, overwritesprayedfile));
        }
        catch (RemoteException e) {
            log.error("Error: Could not spray file" + e.getLocalizedMessage());
        }
        catch (ArrayOfEspExceptionWrapper e) {
            log.error(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public boolean sprayCustomCSVHPCCFile(String fileName, String targetFileLabel, String targetCluster, String escapedEscapeSequence, String escapedFieldDelim, String escapedQuote, String escapedRecTerminator, boolean overwritesprayedfile, HPCCFileSprayClient.SprayVariableFormat format) {
        boolean success = true;
        try {
            success = this.sprayVariableHPCCFile(fileName, targetFileLabel, targetCluster, new DelimitedDataOptions(escapedRecTerminator, escapedFieldDelim, escapedEscapeSequence, escapedQuote), overwritesprayedfile, format);
        }
        catch (Exception e) {
            log.error("Error: Could not spray file");
            success = false;
        }
        return success;
    }

    public boolean sprayDefaultCSVHPCCFile(String fileName, String targetFileLabel, String targetCluster, boolean overwritesprayedfile) {
        boolean success = false;
        try {
            success = this.sprayVariableHPCCFile(fileName, targetFileLabel, targetCluster, new DelimitedDataOptions(), overwritesprayedfile, HPCCFileSprayClient.SprayVariableFormat.DFUff_csv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public boolean sprayVariableHPCCFile(String fileName, String targetFileLabel, String targetCluster, DelimitedDataOptions options, boolean overwritesprayedfile, HPCCFileSprayClient.SprayVariableFormat format) {
        boolean success = false;
        try {
            HPCCFileSprayClient fileSprayClient = this.getFileSprayClient();
            if (fileSprayClient == null) {
                throw new Exception("Could not initialize HPCC FileSpray Client");
            }
            success = this.handleSprayResponse(fileSprayClient.sprayVariableLocalDropZone(options, fileName, targetFileLabel, "", targetCluster, overwritesprayedfile, format));
        }
        catch (RemoteException e) {
            log.error("Error: Could not spray file" + e.getLocalizedMessage());
        }
        catch (ArrayOfEspExceptionWrapper e) {
            log.error(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public boolean handleSprayResponse(ProgressResponseWrapper progressResponseWrapper) throws Exception, ArrayOfEspExceptionWrapper {
        HPCCFileSprayClient fileSprayClient = this.getFileSprayClient();
        if (fileSprayClient == null) {
            throw new Exception("Could not initialize HPCC FileSpray Client");
        }
        return fileSprayClient.handleSprayResponse(progressResponseWrapper, 10, 100);
    }

    public boolean uploadFileToHPCC(String localFileName, String targetFilename, String machineLoginUser, String password) {
        try {
            HPCCFileSprayClient fileSprayClient = this.getFileSprayClient();
            if (fileSprayClient == null) {
                throw new Exception("Could not initialize HPCC File Spray Client");
            }
            fileSprayClient.sftpPutFileOnTargetLandingZone(localFileName, targetFilename, machineLoginUser, password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean httpUploadFileToFirstHPCCLandingZone(String localFileName) {
        try {
            HPCCFileSprayClient fileSprayClient = this.getFileSprayClient();
            if (fileSprayClient == null) {
                throw new Exception("Could not initialize HPCC File Spray Client");
            }
            fileSprayClient.uploadFileLocalDropZone(new File(localFileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String submitECLandGetResults(WorkunitWrapper wu) throws Exception {
        String results = null;
        HPCCWsWorkUnitsClient wsWorkunitsClient = this.getWsWorkunitsClient();
        try {
            if (wsWorkunitsClient == null) {
                throw new Exception("Could not initialize HPCC WsWorkUnits Client");
            }
            results = wsWorkunitsClient.createAndRunWUFromECLAndGetResults(wu);
        }
        catch (ArrayOfECLExceptionWrapper e) {
            log.error("Error submitting ECL: " + e.toString());
        }
        catch (Exception e) {
            log.error("Error submitting ECL: " + e.getLocalizedMessage());
            throw e;
        }
        return results;
    }

    public List<List<Object>> submitECLandGetResultsList(WorkunitWrapper wu) throws Exception {
        String results = this.submitECLandGetResults(wu);
        List<List<Object>> resultsList = Utils.parseECLResults(results);
        return resultsList;
    }

    public String submitECLandGetWUID(WorkunitWrapper wu) {
        String WUID = null;
        HPCCWsWorkUnitsClient wsWorkunitsClient = this.getWsWorkunitsClient();
        try {
            if (wsWorkunitsClient == null) {
                throw new Exception("Could not initialize HPCC WsWorkUnits Client");
            }
            WUID = wsWorkunitsClient.createAndRunWUFromECLAndGetWUID(wu);
        }
        catch (ArrayOfECLExceptionWrapper | ArrayOfEspExceptionWrapper e) {
            log.error("Error submitting ECL: " + e.toString());
        }
        catch (Exception e) {
            log.error("Error submitting ECL: " + e.getLocalizedMessage());
        }
        return WUID;
    }

    public String getProtocol() {
        return this.connection.getProtocol();
    }

    public String getHost() {
        return this.connection.getHost();
    }

    public int getPortInt() {
        return this.connection.getPortInt();
    }

    public String getUserName() {
        return this.connection.getUserName();
    }

    public String getPassword() {
        return this.connection.getPassword();
    }

    @Override
    protected boolean isComplete() {
        return true;
    }

    @Override
    protected void fastRefresh() {
    }

    @Override
    protected void fullRefresh() {
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof HPCCWsClient)) {
            return false;
        }
        HPCCWsClient that = (HPCCWsClient)aThat;
        return EqualsUtil.areEqual(this.getConnection(), that.getConnection());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.connection);
        return result;
    }
}

