/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.hpccsystems.ws.client.utils.StackHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatasetParser {
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public DatasetParser(long start, InputSource is, Map<Long, Map<Integer, String>> data) {
        SAXParser parser = null;
        this.parserFactory.setValidating(false);
        try {
            parser = this.parserFactory.newSAXParser();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        DatasetHandler handler = new DatasetHandler(start, data);
        try {
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DatasetHandler
    extends StackHandler {
        Map<Long, Map<Integer, String>> data;
        long row;
        int col;

        DatasetHandler(long row, Map<Long, Map<Integer, String>> data) {
            this.row = row;
            this.col = 0;
            this.data = data;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            assert (!this.elementStack.empty());
            switch (this.elementStack.size()) {
                case 2: {
                    ++this.row;
                    this.col = 0;
                    break;
                }
                case 3: {
                    StackHandler.Element e = (StackHandler.Element)this.elementStack.peek();
                    if (this.col == 0) {
                        this.data.put(this.row, new HashMap());
                    }
                    this.data.get(this.row).put(this.col, e.content.toString());
                    ++this.col;
                    break;
                }
            }
            super.endElement(uri, localName, qName);
        }
    }
}

