/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);
    static final char LINUX_SEP = '/';
    static final char WIN_SEP = '\\';
    static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.sss'Z'";
    private static final byte[] NEWLINE = "\r\n".getBytes();
    private static final byte[] PREFIX = "--".getBytes();
    private static final String BOUNDRYPREFIX = "--------------------";
    protected static OSType detectedOS;

    public static String parseVersionFromWSDLURL(String wsdlurl) {
        String[] pairs;
        if (wsdlurl != null && wsdlurl.length() > 0 && (pairs = wsdlurl.split("ver_=")).length > 1) {
            return pairs[1];
        }
        return "";
    }

    @Deprecated
    public static void println(PrintStream stream, String message, boolean onlyifverbose, boolean verbosemode) {
        if (onlyifverbose && verbosemode) {
            log.warn(message);
        } else {
            log.info(message);
        }
    }

    @Deprecated
    public static void print(PrintStream stream, String message, boolean onlyifverbose, boolean verbosemode) {
        if (onlyifverbose && verbosemode) {
            log.warn(message);
        } else {
            log.info(message);
        }
    }

    public static void log(String message, LogLevel logLevel) {
        switch (logLevel) {
            case DEBUG: {
                log.debug(message);
                break;
            }
            case ERROR: {
                log.error(message);
                break;
            }
            case FATAL: {
                log.fatal(message);
                break;
            }
            case INFO: {
                log.info(message);
                break;
            }
            case TRACE: {
                log.trace(message);
                break;
            }
            case WARN: {
                log.warn(message);
                break;
            }
            default: {
                log.trace(message);
            }
        }
    }

    public static List<List<Object>> parseECLResults(String results) {
        Utils.println(System.out, "Parsing ECL results...", false, false);
        Utils.println(System.out, results, true, false);
        ArrayList<List<Object>> resultList = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(results.getBytes("UTF-8")));
            Utils.println(System.out, " Root element: " + doc.getDocumentElement().getNodeName(), false, false);
            NodeList exceptionList = doc.getElementsByTagName("Exception");
            if (exceptionList.getLength() > 0) {
                for (int temp = 0; temp < exceptionList.getLength(); ++temp) {
                    resultList = new ArrayList<List<Object>>();
                    Node nNode = exceptionList.item(temp);
                    if (nNode.getNodeType() != 1) continue;
                    ArrayList<String> row = new ArrayList<String>();
                    NodeList datasetchildnodes = nNode.getChildNodes();
                    for (int rowsindex = 0; rowsindex < datasetchildnodes.getLength(); ++rowsindex) {
                        Node ithrow = datasetchildnodes.item(rowsindex);
                        Element ithrowelement = (Element)ithrow;
                        row.add(ithrowelement.getNodeName() + ": " + ithrowelement.getTextContent());
                    }
                    resultList.add(row);
                }
            }
            NodeList nList = doc.getElementsByTagName("Dataset");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                System.out.println("  Current Element :" + nNode.getNodeName());
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                System.out.println("  Dataset Name: " + eElement.getAttribute("name"));
                if (resultList == null) {
                    resultList = new ArrayList();
                }
                NodeList datasetchildnodes = nNode.getChildNodes();
                for (int rowsindex = 0; rowsindex < datasetchildnodes.getLength(); ++rowsindex) {
                    Node ithrow = datasetchildnodes.item(rowsindex);
                    if (!(ithrow instanceof CharacterData)) {
                        Element ithrowelement = (Element)ithrow;
                        resultList.add(Utils.parseECLRowResultsToList(ithrowelement));
                        continue;
                    }
                    CharacterData data = (CharacterData)ithrow;
                    Utils.println(System.out, "ignoring: " + data, false, false);
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    private static String nodeToString(Node node) throws TransformerException {
        StringWriter buf = new StringWriter();
        Transformer xform = TransformerFactory.newInstance().newTransformer();
        xform.setOutputProperty("omit-xml-declaration", "yes");
        xform.transform(new DOMSource(node), new StreamResult(buf));
        return buf.toString();
    }

    public static String extactResultSchema(String results) {
        Utils.println(System.out, "Parsing ECL results...", false, false);
        Utils.println(System.out, results, true, false);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(results.getBytes("UTF-8")));
            Utils.println(System.out, " Root element: " + doc.getDocumentElement().getNodeName(), false, false);
            NodeList exceptionList = doc.getElementsByTagName("Exception");
            if (exceptionList.getLength() > 0) {
                return null;
            }
            NodeList nList = doc.getElementsByTagName("XmlSchema");
            if (nList.getLength() > 0) {
                return Utils.nodeToString(nList.item(0));
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<List<Object>> parseOutResultSchema(String results) {
        Utils.println(System.out, "Parsing ECL results...", false, false);
        Utils.println(System.out, results, true, false);
        ArrayList schemaCols = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(results.getBytes("UTF-8")));
            Utils.println(System.out, " Root element: " + doc.getDocumentElement().getNodeName(), false, false);
            NodeList exceptionList = doc.getElementsByTagName("Exception");
            if (exceptionList.getLength() > 0) {
                return null;
            }
            NodeList rowNodeList = doc.getElementsByTagName("Row");
            if (rowNodeList.getLength() > 0) {
                schemaCols = new ArrayList();
                Node rowNode = rowNodeList.item(0);
                NodeList rowChildNodes = rowNode.getChildNodes();
                for (int rowChildNodeIndex = 0; rowChildNodeIndex < rowChildNodes.getLength(); ++rowChildNodeIndex) {
                    ArrayList<Object> schemaCol = new ArrayList<Object>();
                    Node rowChild = rowChildNodes.item(rowChildNodeIndex);
                    schemaCol.add(0, rowChild.getNodeName());
                    schemaCol.add(1, rowChild.getNodeType());
                    schemaCols.add(rowChildNodeIndex, schemaCol);
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return schemaCols;
    }

    private static List<Object> parseECLRowResultsToList(Element rowelement) {
        ArrayList<Object> row = null;
        try {
            String rowelementname = rowelement.getNodeName();
            if (rowelementname.equalsIgnoreCase("ROW")) {
                row = new ArrayList<Object>();
                NodeList childNodes = rowelement.getChildNodes();
                for (int rowdataindex = 0; rowdataindex < childNodes.getLength(); ++rowdataindex) {
                    Object cell = null;
                    Node rowdataitem = childNodes.item(rowdataindex);
                    NodeList childSubNodes = rowdataitem.getChildNodes();
                    int length = childSubNodes.getLength();
                    if (length > 1) {
                        cell = new ArrayList();
                        for (int subchildindex = 0; subchildindex < length; ++subchildindex) {
                            ((List)cell).add(Utils.parseECLRowResultsToList((Element)childSubNodes.item(subchildindex)));
                        }
                    } else {
                        cell = new String(rowdataitem.getTextContent());
                    }
                    row.add(cell);
                }
            }
        }
        catch (Exception e) {
            Utils.println(System.err, "Error parsing ECL Results: " + e.getLocalizedMessage(), false, false);
        }
        return row;
    }

    public static String eclResultsToString(List<List<Object>> resultlist, String celldelimiter, String rowdelimiter) {
        StringBuilder resultstr = new StringBuilder();
        int rowscount = resultlist.size();
        for (int rowindex = 0; rowindex < rowscount; ++rowindex) {
            List<Object> row = resultlist.get(rowindex);
            if (row != null) {
                int rowlength = row.size();
                for (int cellindex = 0; cellindex < rowlength; ++cellindex) {
                    Object cell = row.get(cellindex);
                    if (cell != null) {
                        if (cell instanceof String) {
                            resultstr.append((String)cell);
                        } else if (cell instanceof List) {
                            resultstr.append("[ ");
                            for (Object subcell : (List)cell) {
                                if (subcell != null) {
                                    if (subcell instanceof String) {
                                        resultstr.append((String)subcell);
                                        continue;
                                    }
                                    if (!(subcell instanceof List)) continue;
                                    resultstr.append(Utils.eclResultsToString((List)cell, celldelimiter, " | "));
                                    continue;
                                }
                                resultstr.append("NULL");
                            }
                            resultstr.append(" ]");
                        }
                    } else {
                        resultstr.append("NULL");
                    }
                    if (cellindex >= rowlength - 1) continue;
                    resultstr.append(celldelimiter);
                }
            }
            if (rowindex >= rowscount - 1) continue;
            resultstr.append(rowdelimiter);
        }
        return resultstr.toString();
    }

    public void writeField(OutputStream out, String boundary, String name, char value) throws IOException {
        this.writeField(out, boundary, name, Character.valueOf(value).charValue());
    }

    public void writeField(OutputStream out, String boundary, String name, String value) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        if (value == null) {
            value = "";
        }
        out.write(PREFIX);
        out.write(boundary.getBytes());
        out.write(NEWLINE);
        out.write(("Content-Disposition: form-data; name=\"" + name + "\"").getBytes());
        out.write(NEWLINE);
        out.write(NEWLINE);
        out.write(value.getBytes());
        out.write(NEWLINE);
        out.flush();
    }

    public void writeFile(OutputStream out, String name, String mimeType, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File cannot be a directory.");
        }
        this.writeFile(out, Utils.createBoundary(), name, mimeType, file.getCanonicalPath(), new FileInputStream(file));
    }

    public void writeFile(OutputStream out, String boundary, String name, String mimeType, String fileName, InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        out.write(PREFIX);
        out.write(boundary.getBytes());
        out.write(NEWLINE);
        out.write(("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"").getBytes());
        out.write(NEWLINE);
        if (mimeType != null) {
            out.write(("Content-Type: " + mimeType).getBytes());
            out.write(NEWLINE);
        }
        out.write(NEWLINE);
        byte[] data = new byte[1024];
        int r = 0;
        while ((r = is.read(data, 0, data.length)) != -1) {
            out.write(data, 0, r);
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        out.write(NEWLINE);
        out.flush();
    }

    public static void writeFile(OutputStream out, String boundary, String mimeType, String fileName, byte[] data) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Outputstream cannot be null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        Utils.startMulti(out, fileName, boundary, mimeType);
        out.write(data, 0, data.length);
        Utils.closeMulti(out, boundary);
    }

    public static void startMulti(OutputStream out, String filename, String boundary, String mimeType) throws IOException {
        out.write(PREFIX);
        out.write(boundary.getBytes());
        out.write(NEWLINE);
        out.write(("Content-Disposition: form-data; name=\"FilesToUpload\"; filename=\"" + filename + "\"").getBytes());
        out.write(NEWLINE);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        out.write(("Content-Type: " + mimeType).getBytes());
        out.write(NEWLINE);
        out.write(NEWLINE);
    }

    public static void closeMulti(OutputStream out, String boundary) throws IOException {
        out.write(NEWLINE);
        out.write(PREFIX);
        out.write(boundary.getBytes());
        out.write(PREFIX);
        out.write(NEWLINE);
        out.flush();
    }

    public static URLConnection createConnection(URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("POST");
        }
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setDefaultUseCaches(false);
        urlConn.setRequestProperty("Connection", "Keep-Alive");
        urlConn.setRequestProperty("DNT", "1");
        urlConn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        urlConn.setRequestProperty("ENCTYPE", "multipart/form-data");
        return urlConn;
    }

    public static String createBoundary() {
        return BOUNDRYPREFIX + Long.toString(System.currentTimeMillis(), 16);
    }

    public static OSType getOperatingSystemType() {
        if (detectedOS == null) {
            String OS = System.getProperty("os.name", "generic").toLowerCase();
            detectedOS = OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0 ? OSType.MacOS : (OS.indexOf("win") >= 0 ? OSType.Windows : (OS.indexOf("nux") >= 0 ? OSType.Linux : OSType.Other));
        }
        return detectedOS;
    }

    public static boolean currentOSisLinux() {
        return Utils.getOperatingSystemType() == OSType.Linux;
    }

    public static <T extends Enum<T>> T findEnumValFromString(Class<T> enumclass, String strvalue) {
        for (Enum enumValue : (Enum[])enumclass.getEnumConstants()) {
            if (!enumValue.name().equalsIgnoreCase(strvalue)) continue;
            return (T)enumValue;
        }
        throw new IllegalArgumentException(enumclass.getName() + ".'" + strvalue + "' is not valid.");
    }

    public static String dateToUTCString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_FORMAT);
        return df.format(date);
    }

    public static Date UTCStringToDate(String utc) throws ParseException {
        if (utc == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_FORMAT);
        return df.parse(utc);
    }

    public static enum HPCCEnvOSCode {
        MachineOsW2K(0),
        MachineOsSolaris(1),
        MachineOsLinux(2),
        MachineOsUnknown(3);

        private int code;
        private String name;

        private HPCCEnvOSCode(int code) {
            this.code = code;
            switch (code) {
                case 0: {
                    this.name = "W2K";
                    break;
                }
                case 1: {
                    this.name = "Solaris";
                    break;
                }
                case 2: {
                    this.name = "Linux";
                    break;
                }
                default: {
                    this.name = "Unknown";
                }
            }
        }

        public HPCCEnvOSCode fromName(String name) {
            if (name == null || name.length() == 0) {
                return MachineOsUnknown;
            }
            if (name.equalsIgnoreCase("W2k")) {
                return MachineOsW2K;
            }
            if (name.equalsIgnoreCase("Solaris")) {
                return MachineOsSolaris;
            }
            if (name.equalsIgnoreCase("Linux")) {
                return MachineOsLinux;
            }
            return MachineOsUnknown;
        }

        public static HPCCEnvOSCode fromCode(int code) {
            switch (code) {
                case 0: {
                    return MachineOsW2K;
                }
                case 1: {
                    return MachineOsSolaris;
                }
                case 2: {
                    return MachineOsLinux;
                }
            }
            return MachineOsUnknown;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Other;

    }

    public static enum LogLevel {
        DEBUG,
        ERROR,
        FATAL,
        INFO,
        TRACE,
        WARN;

    }
}

