/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers.wsdfu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.hpccsystems.ws.client.antlr.CaseControlStringStream;
import org.hpccsystems.ws.client.antlr.EclRecordLexer;
import org.hpccsystems.ws.client.antlr.EclRecordParser;
import org.hpccsystems.ws.client.antlr.EclRecordReader;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_57.ArrayOfDFUFilePartsOnCluster;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_57.DFUDataColumn;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_57.DFUFileDetail;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_57.DFUFilePartsOnCluster;
import org.hpccsystems.ws.client.utils.FileFormat;
import org.hpccsystems.ws.client.wrappers.EclRecordWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUDataColumnWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFURecordDefWrapper;

public class DFUFileDetailWrapper
extends DFUFileDetail {
    private static final long serialVersionUID = 155L;
    private ArrayList<DFUDataColumnWrapper> columns;
    private String firstline = null;
    private boolean hasheader = false;

    public boolean hasHeader() {
        return this.hasheader;
    }

    public void setHasheader(boolean hasheader) {
        this.hasheader = hasheader;
    }

    public DFUFileDetailWrapper(DFUFileDetail base) {
        this.copy(base);
    }

    public DFUFileDetailWrapper() {
    }

    public String getFirstline() {
        return this.firstline;
    }

    public void setFirstline(String firstline) {
        this.firstline = firstline;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BrowseData:").append(this.getBrowseData()).append("\n");
        sb.append("CompressedFileSize:").append(this.getCompressedFileSize()).append("\n");
        if (this.getContentType() != null) {
            sb.append("ContentType:").append(this.getContentType()).append("\n");
        }
        if (this.getCsvEscape() != null) {
            sb.append("CsvEscape:").append(this.getCsvEscape()).append("\n");
        }
        if (this.getCsvQuote() != null) {
            sb.append("CsvQuote:").append(this.getCsvQuote()).append("\n");
        }
        if (this.getCsvSeparate() != null) {
            sb.append("CsvSeparate:").append(this.getCsvSeparate()).append("\n");
        }
        if (this.getCsvTerminate() != null) {
            sb.append("CsvTerminate:").append(this.getCsvTerminate()).append("\n");
        }
        if (this.getDescription() != null) {
            sb.append("Description:").append(this.getDescription()).append("\n");
        }
        sb.append("DFUFilePartsOnClusters:").append(this.getDFUFilePartsOnClusters()).append("\n");
        if (this.getDir() != null) {
            sb.append("Dir:").append(this.getDir()).append("\n");
        }
        if (this.getEcl() != null) {
            sb.append("Ecl:").append(this.getEcl()).append("\n");
        }
        if (this.getFilename() != null) {
            sb.append("Filename:").append(this.getFilename()).append("\n");
        }
        if (this.getFilesize() != null) {
            sb.append("Filesize:").append(this.getFilesize()).append("\n");
        }
        if (this.getFirstline() != null) {
            sb.append("FirstLine:").append(this.getFirstline()).append("\n");
        }
        if (this.getFormat() != null) {
            sb.append("Format:").append(this.getFormat()).append("\n");
        }
        sb.append("FromRoxieCluster:").append(this.getFromRoxieCluster()).append("\n");
        if (this.getGraphs() != null) {
            sb.append("Graphs:").append(this.getGraphs()).append("\n");
        }
        if (String.valueOf(this.hasHeader()) != null) {
            sb.append("hasHeader:").append(String.valueOf(this.hasHeader())).append("\n");
        }
        if (String.valueOf(this.getIsCompressed()) != null) {
            sb.append("IsCompressed:").append(String.valueOf(this.getIsCompressed())).append("\n");
        }
        if (String.valueOf(this.getIsSuperfile()) != null) {
            sb.append("IsSuperfile:").append(String.valueOf(this.getIsSuperfile())).append("\n");
        }
        if (this.getJobName() != null) {
            sb.append("JobName:").append(this.getJobName()).append("\n");
        }
        if (this.getMaxRecordSize() != null) {
            sb.append("MaxRecordSize:").append(this.getMaxRecordSize()).append("\n");
        }
        if (this.getModified() != null) {
            sb.append("Modified:").append(this.getModified()).append("\n");
        }
        if (this.getName() != null) {
            sb.append("Name:").append(this.getName()).append("\n");
        }
        if (this.getNodeGroup() != null) {
            sb.append("NodeGroup:").append(this.getNodeGroup()).append("\n");
        }
        sb.append("NumParts:").append(this.getNumParts()).append("\n");
        if (this.getOwner() != null) {
            sb.append("Owner:").append(this.getOwner()).append("\n");
        }
        if (this.getPathMask() != null) {
            sb.append("PathMask:").append(this.getPathMask()).append("\n");
        }
        if (this.getPersistent() != null) {
            sb.append("Persistent:").append(this.getPersistent()).append("\n");
        }
        if (this.getPrefix() != null) {
            sb.append("Prefix:").append(this.getPrefix()).append("\n");
        }
        if (this.getRecordCount() != null) {
            sb.append("RecordCount:").append(this.getRecordCount()).append("\n");
        }
        if (this.getRecordSize() != null) {
            sb.append("RecordSize:").append(this.getRecordSize()).append("\n");
        }
        sb.append("ShowFileContent:").append(this.getShowFileContent()).append("\n");
        sb.append("Stat:").append(this.getStat()).append("\n");
        if (this.getSubfiles() != null) {
            sb.append("Subfiles:").append(this.getSubfiles()).append("\n");
        }
        sb.append("Superfiles:").append(this.getSuperfiles()).append("\n");
        if (this.getUserPermission() != null) {
            sb.append("UserPermission:").append(this.getUserPermission()).append("\n");
        }
        if (this.getWuid() != null) {
            sb.append("Wuid:").append(this.getWuid()).append("\n");
        }
        if (this.getColumns() != null) {
            sb.append("Columns:");
            for (DFUDataColumnWrapper col : this.getColumns()) {
                sb.append("    ").append(col.toString());
            }
        }
        return sb.toString();
    }

    private void copy(DFUFileDetail base) {
        if (base == null) {
            return;
        }
        this.setBinInfo(base.getBinInfo());
        this.setBrowseData(base.getBrowseData());
        this.setCompressedFileSize(base.getCompressedFileSize());
        this.setContentType(base.getContentType());
        this.setCsvEscape(base.getCsvEscape());
        this.setCsvQuote(base.getCsvQuote());
        this.setCsvSeparate(base.getCsvSeparate());
        this.setCsvTerminate(base.getCsvTerminate());
        this.setDescription(base.getDescription());
        this.setDFUFilePartsOnClusters(base.getDFUFilePartsOnClusters());
        this.setDir(base.getDir());
        this.setEcl(base.getEcl());
        this.setFilename(base.getFilename());
        this.setFilesize(base.getFilesize());
        this.setFormat(base.getFormat());
        this.setFromRoxieCluster(base.getFromRoxieCluster());
        this.setGraphs(base.getGraphs());
        this.setIsCompressed(base.getIsCompressed());
        this.setIsSuperfile(base.getIsSuperfile());
        this.setJobName(base.getJobName());
        this.setJsonInfo(base.getJsonInfo());
        this.setMaxRecordSize(base.getMaxRecordSize());
        this.setModified(base.getModified());
        this.setName(base.getName());
        this.setNodeGroup(base.getNodeGroup());
        this.setNumParts(base.getNumParts());
        this.setOwner(base.getOwner());
        this.setPathMask(base.getPathMask());
        this.setPercentCompressed(base.getPercentCompressed());
        this.setPersistent(base.getPersistent());
        this.setPrefix(base.getPrefix());
        this.setProtectList(base.getProtectList());
        this.setRecordCount(base.getRecordCount());
        this.setRecordCountInt64(base.getRecordCountInt64());
        this.setRecordSize(base.getRecordSize());
        this.setRecordSizeInt64(base.getRecordSizeInt64());
        this.setShowFileContent(base.getShowFileContent());
        this.setStat(base.getStat());
        this.setSubfiles(base.getSubfiles());
        this.setSuperfiles(base.getSuperfiles());
        this.setUserPermission(base.getUserPermission());
        this.setWuid(base.getWuid());
        this.setIsCompressed(base.getIsCompressed());
    }

    public ArrayList<DFUDataColumnWrapper> getColumns() {
        if (this.columns == null) {
            return new ArrayList<DFUDataColumnWrapper>();
        }
        return this.columns;
    }

    public void setColumns(List<DFUDataColumnWrapper> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i) instanceof DFUDataColumnWrapper) {
                this.columns.add(columns.get(i));
                continue;
            }
            this.columns.add(new DFUDataColumnWrapper(columns.get(i)));
        }
    }

    public void setColumns(DFUDataColumn[] childColumns) {
        if (childColumns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList();
        for (int i = 0; i < childColumns.length; ++i) {
            this.columns.add(new DFUDataColumnWrapper(childColumns[i]));
        }
    }

    public FileFormat getFileType() {
        if (this.getName() == null) {
            return FileFormat.UNKNOWN;
        }
        boolean hasxpath = this.hasEcl() && this.getEcl().toLowerCase().contains("xpath");
        FileFormat fileFormatFromContent = FileFormat.getFileFormat(this.getContentType());
        if (fileFormatFromContent == FileFormat.FLAT) {
            if (!this.hasEcl() && this.isSprayedCsv()) {
                return FileFormat.CSV;
            }
            return FileFormat.FLAT;
        }
        if (fileFormatFromContent == FileFormat.CSV) {
            return FileFormat.CSV;
        }
        if (fileFormatFromContent == FileFormat.XML) {
            return FileFormat.XML;
        }
        if (fileFormatFromContent == FileFormat.KEYED || this.isIndex()) {
            return FileFormat.KEYED;
        }
        if (fileFormatFromContent == FileFormat.UNKNOWN && (this.getContentType() == null || this.getContentType().equals(""))) {
            FileFormat fileFormat = FileFormat.getFileFormat(this.getFormat());
            if (this.getIsSuperfile() && fileFormat != FileFormat.KEYED && !this.isIndex()) {
                return FileFormat.FLAT;
            }
            if (FileFormat.CSV == fileFormat) {
                return FileFormat.CSV;
            }
            if (FileFormat.XML == fileFormat) {
                return FileFormat.XML;
            }
            if (this.getFormat() != null && this.getFormat().toLowerCase().startsWith("utf")) {
                if (hasxpath) {
                    return FileFormat.XML;
                }
                return FileFormat.CSV;
            }
            if (fileFormat == FileFormat.UNKNOWN && (this.getFormat() == null || this.getFormat().equals("")) && hasxpath) {
                return FileFormat.XML;
            }
            if (this.hasEcl()) {
                return FileFormat.FLAT;
            }
            if (!this.isSprayedCsv()) {
                return FileFormat.FLAT;
            }
            return FileFormat.UNKNOWN;
        }
        return FileFormat.UNKNOWN;
    }

    public boolean hasChildDatasets() {
        if (this.getColumns().size() == 0) {
            return false;
        }
        for (DFUDataColumnWrapper info : this.getColumns()) {
            if (!"table".equalsIgnoreCase(info.getColumnEclType())) continue;
            return true;
        }
        return false;
    }

    public EclRecordWrapper deduceFields() throws Exception {
        FileFormat fileType = this.getFileType();
        if (fileType == FileFormat.FLAT || fileType == FileFormat.KEYED) {
            if (this.getEcl() != null && !this.getEcl().isEmpty()) {
                EclRecordWrapper info = DFUFileDetailWrapper.getRecordFromECL(this.getEcl());
                info = this.addKeyInfo(info);
                info.setFileType(fileType);
                return info;
            }
            EclRecordWrapper ei = new EclRecordWrapper(new DFURecordDefWrapper(this.getColumns()));
            ei.setFileType(fileType);
            return ei;
        }
        if (fileType == FileFormat.XML) {
            if (this.hasEcl()) {
                EclRecordWrapper ei = DFUFileDetailWrapper.getRecordFromECL(this.getEcl());
                ei.setFileType(fileType);
                return ei;
            }
            EclRecordWrapper ei = new EclRecordWrapper(new DFURecordDefWrapper(this.getColumns()));
            ei.setFileType(fileType);
            return ei;
        }
        if (fileType == FileFormat.CSV) {
            if (!this.isSprayedCsv()) {
                EclRecordWrapper ei = DFUFileDetailWrapper.getRecordFromECL(this.getEcl());
                ei.setFileType(fileType);
                return ei;
            }
            if (this.getFirstline() != null && !this.getFirstline().isEmpty()) {
                ArrayList<DFUDataColumnWrapper> fields = new ArrayList<DFUDataColumnWrapper>();
                String sep = this.getCsvSeparate();
                if (sep.startsWith("\\")) {
                    sep = sep.substring(1);
                }
                String[] flds = this.getFirstline().split(sep);
                for (int i = 0; i < flds.length; ++i) {
                    DFUDataColumnWrapper du = new DFUDataColumnWrapper();
                    if (this.hasHeader() && this.isFirstRowValidFieldNames()) {
                        String fldval = flds[i].trim();
                        if (this.getCsvQuote() != null && !this.getCsvQuote().isEmpty() && fldval.startsWith(this.getCsvQuote()) && fldval.endsWith(this.getCsvQuote())) {
                            fldval = fldval.substring(1, fldval.length() - 1);
                        }
                        du.setColumnLabel(fldval);
                    } else {
                        du.setColumnLabel("Field" + String.valueOf(i + 1));
                    }
                    du.setColumnType("STRING");
                    du.setColumnEclType("STRING");
                    fields.add(new DFUDataColumnWrapper(du));
                }
                EclRecordWrapper ei = new EclRecordWrapper(new DFURecordDefWrapper(fields));
                ei.setFileType(fileType);
                return ei;
            }
            EclRecordWrapper ei = new EclRecordWrapper(new DFURecordDefWrapper(this.getColumns()));
            ei.setFileType(fileType);
            return ei;
        }
        EclRecordWrapper ei = new EclRecordWrapper(new DFURecordDefWrapper(this.getColumns()));
        ei.setFileType(fileType);
        return ei;
    }

    public static EclRecordWrapper getRecordFromECL(String eclRecordDefinition) throws Exception {
        EclRecordWrapper info = DFUFileDetailWrapper.getRecordEcl(eclRecordDefinition);
        return info;
    }

    public boolean isSprayedCsv() {
        DFURecordDefWrapper dfu;
        HashMap<String, DFURecordDefWrapper> info;
        return this.getEcl() != null && !this.getEcl().isEmpty() ? (info = DFUFileDetailWrapper.getRecordEcl(this.getEcl()).getRecordsets()).size() == 1 && (dfu = info.values().iterator().next()).getChildColumns().size() <= 2 && dfu.getChildColumns().get(0).getColumnLabel().equals("line") : this.getColumns() != null && this.getColumns().size() <= 2 && this.getColumns().get(0).getColumnLabel().equals("line");
    }

    public boolean hasEcl() {
        return this.getEcl() != null && !this.getEcl().isEmpty();
    }

    public boolean isFirstRowValidFieldNames() {
        if (FileFormat.CSV != this.getFileType()) {
            return false;
        }
        if (this.getFirstline() == null || this.getFirstline().isEmpty()) {
            return false;
        }
        String[] flds = this.getFirstline().split(this.getCsvSeparate());
        if (!this.isSprayedCsv() && flds.length != this.getColumns().size()) {
            return false;
        }
        for (int i = 0; i < flds.length; ++i) {
            String fld;
            String fldval = flds[i].trim();
            if (this.getCsvQuote() != null && !this.getCsvQuote().isEmpty() && fldval.startsWith(this.getCsvQuote()) && fldval.endsWith(this.getCsvQuote())) {
                fldval = fldval.substring(1, fldval.length() - 1);
            }
            if ((fld = fldval.replaceAll("[^A-Za-z0-9_]", "")).equals(fldval)) continue;
            return false;
        }
        return true;
    }

    private EclRecordWrapper addKeyInfo(EclRecordWrapper input) {
        if (this.getColumns() == null) {
            return input;
        }
        ArrayList<String> keyed = new ArrayList<String>();
        for (DFUDataColumnWrapper d : this.getColumns()) {
            if (d == null || d.getIsKeyedColumn() == null || !d.getIsKeyedColumn().booleanValue()) continue;
            keyed.add(d.getColumnLabel());
        }
        ArrayList<String> natural = new ArrayList<String>();
        for (DFUDataColumnWrapper dFUDataColumnWrapper : this.getColumns()) {
            if (dFUDataColumnWrapper == null || dFUDataColumnWrapper.getIsNaturalColumn() == null || !dFUDataColumnWrapper.getIsNaturalColumn().booleanValue()) continue;
            natural.add(dFUDataColumnWrapper.getColumnLabel());
        }
        for (Map.Entry entry : input.getRecordsets().entrySet()) {
            if (!((String)entry.getKey()).startsWith(EclRecordWrapper.UNNAMED)) continue;
            for (DFUDataColumnWrapper d : ((DFURecordDefWrapper)entry.getValue()).getChildColumns()) {
                if (keyed.contains(d.getColumnLabel())) {
                    d.setIsKeyedColumn(true);
                }
                if (!natural.contains(d.getColumnLabel())) continue;
                d.setIsNaturalColumn(true);
            }
        }
        return input;
    }

    public boolean isIndex() {
        if (this.getColumns() == null) {
            return false;
        }
        for (DFUDataColumnWrapper d : this.getColumns()) {
            if (!d.getIsKeyedColumn().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void setColumns(ArrayList<DFUDataColumnWrapper> columns2) {
        this.columns = columns2;
    }

    public static EclRecordWrapper getRecordEcl(String content) {
        if (content == null || content.isEmpty()) {
            return new EclRecordWrapper();
        }
        EclRecordReader cr = new EclRecordReader();
        try {
            CaseControlStringStream is = new CaseControlStringStream(content);
            is.toUpperCase = true;
            EclRecordLexer dl = new EclRecordLexer((CharStream)is);
            EclRecordParser dp = new EclRecordParser((TokenStream)new BufferedTokenStream((TokenSource)dl));
            cr.getErrorHandler().attach(dl);
            cr.getErrorHandler().attach(dp);
            cr.setParser(dp);
            EclRecordParser.ProgramContext pc = dp.program();
            ParseTreeWalker pw = new ParseTreeWalker();
            pw.walk((ParseTreeListener)cr, (ParseTree)pc);
        }
        catch (Exception e) {
            cr.getErrorHandler().getErrors().add("Error parsing Record:" + e.getMessage());
        }
        if (cr.getEclRecordWrapper() != null) {
            cr.getEclRecordWrapper().setOriginalEcl(content);
        }
        cr.getEclRecordWrapper().setParseErrors(cr.getErrorHandler().getErrors());
        return cr.getEclRecordWrapper();
    }

    public Set<String> getClusters() {
        ArrayOfDFUFilePartsOnCluster clstrs = super.getDFUFilePartsOnClusters();
        Set<String> clusters = Arrays.stream(clstrs.getDFUFilePartsOnCluster()).map(DFUFilePartsOnCluster::getCluster).collect(Collectors.toSet());
        return clusters;
    }
}

