/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HPCCPreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    protected static final Logger log = LogManager.getLogger(HPCCPreemptiveAuthInterceptor.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        log.debug("HPCCPreemptiveAuthInterceptor: Processing preemptive authentication...");
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState.getAuthScheme() == null) {
            log.debug("HPCCPreemptiveAuthInterceptor: No previous authentication scheme found, initializing preemptively...");
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            if (credsProvider == null) {
                log.warn("HPCCPreemptiveAuthInterceptor: No credentials provider found...");
            } else {
                Credentials creds = credsProvider.getCredentials(new AuthScope(AuthScope.ANY_HOST, -1));
                if (creds == null) {
                    log.warn("HPCCPreemptiveAuthInterceptor: No credentials found during preemptive authentication processing...");
                }
                authState.update((AuthScheme)new BasicScheme(), creds);
            }
        }
    }
}

