/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import org.hpccsystems.ws.client.HPCCWsClient;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.utils.ObjectPool;

public class HPCCWsClientPool
extends ObjectPool<HPCCWsClient> {
    private Connection m_connection;
    public static final long DEFAULT_EXPIRE_MILLIS = 60000L;

    public HPCCWsClientPool(String protocol, String targetWsECLWatchAddress, String targetWsECLWatchPort, String user, String password, long timeout) {
        this.m_connection = new Connection(protocol, targetWsECLWatchAddress, targetWsECLWatchPort);
        if (this.m_connection != null) {
            this.m_connection.setCredentials(user, password);
        }
    }

    public HPCCWsClientPool(String protocol, String targetWsECLWatchAddress, String targetWsECLWatchPort, String user, String password) {
        this(protocol, targetWsECLWatchAddress, targetWsECLWatchPort, user, password, 60000L);
    }

    public HPCCWsClientPool(Connection connection) {
        this(connection, 60000L);
    }

    public HPCCWsClientPool(Connection connection, long timeout) {
        super(timeout);
        this.m_connection = connection;
    }

    @Override
    protected HPCCWsClient create() {
        return new HPCCWsClient(this.m_connection);
    }

    @Override
    public boolean validate(HPCCWsClient client) {
        try {
            return client.pingServer();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void expire(HPCCWsClient client) {
        client.updateConnection(null);
    }
}

